<?php

namespace Modules\Maf\app\Http\Controllers\V1;

use App\Http\Controllers\Controller;
use Carbon\Carbon;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Modules\Message\app\Models\Message;
use Morilog\Jalali\Jalalian;

class MessageController extends Controller
{
    public function messages()
    {

        $messages = Message::where('user_id', Auth::user()->id)->get();
        $messages->transform(function ($message) {
            // ابتدا تاریخ و زمان را جدا می‌کنیم
            $dateOnly = explode(' ', $message->created_at)[0];
            // تبدیل تاریخ به جلالی بدون زمان
            $message->time = $this->convertToJalali($dateOnly);
            return $message;
        });
        return Response()->success([
            'messages' => $messages,
        ],'', 200);
    }

    public function read_message(request $request)
    {
        Message::whereIn('id',$request->ids)->update([
            'read' => 1
        ]);

        return Response()->success([
        ],'با موفقیت انجام شد', 200);
    }

    private function convertToJalali($value)
    {
        $carbonDate = Carbon::parse($value);
        return Jalalian::fromCarbon($carbonDate)->format('Y/m/d H:i:s');
    }

}
