<?php

namespace Modules\Maf\app\Http\Controllers\V1;

use App\Http\Controllers\Controller;
use App\Http\Requests\ProfileUpdateRequest;
use Carbon\Carbon;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Storage;
use Modules\Area\app\Models\City;
use Modules\Area\app\Models\Province;
use Modules\Core\app\Http\Controllers\Helpers\File;
use Modules\Note\app\Models\Note;
use Modules\User\app\Models\Education;
use Modules\User\app\Models\Major;
use Modules\User\app\Models\Position;
use Modules\User\app\Models\Profile;
use Modules\User\app\Models\User;
use Modules\User\app\Models\UsersGallery;
use Illuminate\Support\Facades\Validator;
use Morilog\Jalali\Jalalian;

class ProfileController extends Controller
{
    public function city()
    {
        return Response()->success([
            'cities' => City::where('status', 1)->get(),
        ],'', 200);
    }
    public function province()
    {
        return Response()->success([
            'provinces' => Province::where('status', 1)->get(),
        ],'', 200);
    }
    public function education()
    {
        return Response()->success([
            'education' => Education::where('state', 1)->get(),
        ],'', 200);
    }
    public function major()
    {
        return Response()->success([
            'major' => Major::where('state', 1)->get(),
        ],'', 200);
    }
    public function position()
    {
        return Response()->success([
            'position' => Position::all(),
        ],'', 200);
    }
    public function detail()
    {
        $profile = User::with(['profile', 'galleries', 'notes' => function ($query) {
            $query->where('read', 0); // شرط برای فیلتر کردن نوت‌ها
        }])->find(Auth::user()->id);

        Note::where('object_id',Auth::user()->id)->update([
            'read' => 1
        ]);

        return Response()->success([
            'user_profile' => $profile,
        ],'', 200);
    }
    public function show_image($id)
    {
        $gallery = UsersGallery::find($id);
        return Storage::disk('secret')->response($gallery->path_file);
    }
    public function profile(Request $request)
    {
//        print_r(Request()->all());
        $first_name = $request->input('firstname');
        $education_id = $request->input('education_id');
        $major_id = $request->input('major_id');
        $last_name = $request->input('last_name');
        $father_name = $request->input('father_name');
        $latin_first_name = $request->input('latin_first_name');
        $latin_last_name = $request->input('latin_last_name');
        $latin_father_name = $request->input('latin_father_name');
        $certificate_number = $request->input('certificate_number');
        $city_id = $request->input('city_id');
        $city_name = City::find($city_id)->title;
        $province_id = $request->input('province_id');
        $province_name = Province::find($province_id)->title;
        $birth_date = $request->input('birth_date');
        $birth_date = Jalalian::fromFormat('Y-m-d', $birth_date)->toCarbon()->toDateString();
        $gender = $request->input('gender');
        $blood_type = $request->input('blood_type');
        $postal_code = $request->input('postal_code');
        $postal_address = $request->input('postal_address');
        $position_id = $request->input('position_id');

        $old_user_galleries = UsersGallery::where('user_id', Auth::user()->id)->get();

        if (count($old_user_galleries) == 0)
        {
            $national_card = File::imageUpload($request->national_card, 'users', $width = null, $height = null, $disk = 'secret');
            $certificate_card = File::imageUpload($request->certificate_card, 'users', $width = null, $height = null, $disk = 'secret');
            $personal_photo = File::imageUpload($request->personal_photo, 'users', $width = null, $height = null, $disk = 'secret');
            $passport = File::imageUpload($request->passport, 'users', $width = null, $height = null, $disk = 'secret');
            $licence = File::imageUpload($request->licence, 'users', $width = null, $height = null, $disk = 'secret');

            $profile = Profile::create([
                'first_name' => $first_name,
                'user_id' => Auth::user()->id,
                'major_id' => $major_id,
                'education_id' => $education_id,
                'last_name' => $last_name,
                'father_name' => $father_name,
                'latin_first_name' => $latin_first_name,
                'latin_last_name' => $latin_last_name,
                'latin_father_name' => $latin_father_name,
                'certificate_number' => $certificate_number,
                'city_id' => $city_id,
                'city_name' => $city_name,
                'birth_date' => $birth_date,
                'province_id' => $province_id,
                'province_name' => $province_name,
                'gender' => $gender,
                'blood_type' => $blood_type,
                'postal_code' => $postal_code,
                'postal_address' => $postal_address,
                'position_id' => $position_id
            ]);

            $createUserGallery = UsersGallery::create([
                'name' => 'national_card',
                'path_file' => $national_card,
                'user_id' => Auth::user()->id,
            ]);
            $createUserGallery = UsersGallery::create([
                'name' => 'certificate_card',
                'path_file' => $certificate_card,
                'user_id' => Auth::user()->id,
            ]);
            $createUserGallery = UsersGallery::create([
                'name' => 'personal_photo',
                'path_file' => $personal_photo,
                'user_id' => Auth::user()->id,
            ]);
            $createUserGallery = UsersGallery::create([
                'name' => 'passport',
                'path_file' => $passport,
                'user_id' => Auth::user()->id,
            ]);
            $createUserGallery = UsersGallery::create([
                'name' => 'licence',
                'path_file' => $licence,
                'user_id' => Auth::user()->id,
            ]);

            $userUpdate = User::find(Auth::user()->id);
            $userUpdate->state = 'pending';
            $userUpdate->update();

            $userUpdate->notes()->create(
                [
                    'note' => "پروفایل توسط کاربر ویرایش شد",
                    'admin_id' => 0,
                    'user_id' => Auth::user()->id,
                    'state' => '0',
                    'read' => '1',
                ]);

            return Response()->success([

            ],'پروفایل شما با موفقیت ویرایش شد و در انتظار تایید توسط مدیر است', 200);
        }
        else
        {
            $national_card = $old_user_galleries[0]->path_file;
            $certificate_card = $old_user_galleries[1]->path_file;
            $personal_photo = $old_user_galleries[2]->path_file;
            $passport = $old_user_galleries[3]->path_file;
            $licence = $old_user_galleries[4]->path_file;

            if (isset($request->national_card))
            {
                $national_card_delete = File::delete($national_card, $disk = 'secret');
                $national_card = File::uploadImage($request->national_card, 'users', $width = null, $height = null, $disk = 'secret');
                $updateUserGallery = UsersGallery::where('name', 'national_card')->where('user_id', Auth::user()->id)->update([
                    'name' => 'national_card',
                    'path_file' => $national_card,
                    'user_id' => Auth::user()->id,
                ]);
            }
            if (isset($request->certificate_card))
            {
                $certificate_card_delete = File::delete($certificate_card, $disk = 'secret');
                $certificate_card = File::uploadImage($request->certificate_card, 'users', $width = null, $height = null, $disk = 'secret');
                $updateUserGallery = UsersGallery::where('name', 'certificate_card')->where('user_id', Auth::user()->id)->update([
                    'name' => 'certificate_card',
                    'path_file' => $certificate_card,
                    'user_id' => Auth::user()->id,
                ]);
            }
            if (isset($request->personal_photo))
            {
                $personal_photo_delete = File::delete($personal_photo, $disk = 'secret');
                $personal_photo = File::uploadImage($request->personal_photo, 'users', $width = null, $height = null, $disk = 'secret');
                $updateUserGallery = UsersGallery::where('name', 'personal_photo')->where('user_id', Auth::user()->id)->update([
                    'name' => 'personal_photo',
                    'path_file' => $personal_photo,
                    'user_id' => Auth::user()->id,
                ]);
            }
            if (isset($request->passport))
            {
                $passport_delete = File::delete($passport, $disk = 'secret');
                $passport = File::uploadImage($request->passport, 'users', $width = null, $height = null, $disk = 'secret');
                $updateUserGallery = UsersGallery::where('name', 'passport')->where('user_id', Auth::user()->id)->update([
                    'name' => 'passport',
                    'path_file' => $passport,
                    'user_id' => Auth::user()->id,
                ]);
            }
            if (isset($request->licence))
            {
                $licence_delete = File::delete($licence, $disk = 'secret');
                $licence = File::uploadImage($request->licence, 'users', $width = null, $height = null, $disk = 'secret');
                $updateUserGallery = UsersGallery::where('name', 'licence')->where('user_id', Auth::user()->id)->update([
                    'name' => 'licence',
                    'path_file' => $licence,
                    'user_id' => Auth::user()->id,
                ]);
            }

            $profile = Profile::where('user_id', Auth::user()->id)->first();
            $profile->first_name = $first_name;
            $profile->major_id = $major_id;
            $profile->education_id = $education_id;
            $profile->last_name = $last_name;
            $profile->father_name = $father_name;
            $profile->latin_first_name = $latin_first_name;
            $profile->latin_last_name = $latin_last_name;
            $profile->latin_father_name = $latin_father_name;
            $profile->certificate_number = $certificate_number;
            $profile->city_id = $city_id;
            $profile->city_name = $city_name;
            $profile->birth_date = $birth_date;
            $profile->province_id = $province_id;
            $profile->province_name = $province_name;
            $profile->gender = $gender;
            $profile->blood_type = $blood_type;
            $profile->postal_code = $postal_code;
            $profile->postal_address = $postal_address;
            $profile->position_id = $position_id;
            $profile->update();

            $userUpdate = User::find(Auth::user()->id);
            $userUpdate->state = 'pending';
            $userUpdate->update();

            $userUpdate->notes()->create(
                [
                    'note' => "پروفایل توسط کاربر ویرایش شد",
                    'admin_id' => 0,
                    'user_id' => Auth::user()->id,
                    'state' => '0',
                    'read' => '1',
                ]);

            return Response()->success([

            ],'پروفایل شما با موفقیت ویرایش شد و در انتظار تایید توسط مدیر است', 200);
        }
    }
}
