<?php

namespace Modules\Maf\app\Http\Controllers\V1;

use App\Http\Controllers\Controller;
use Carbon\Carbon;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Storage;
use Modules\Core\app\Http\Controllers\Helpers\File;
use Modules\User\app\Models\User;
use Modules\User\app\Models\UsersGallery;
use Modules\Vehicle\app\Models\VehicleBrand;
use Modules\Vehicle\app\Models\VehicleCategory;
use Modules\Vehicle\app\Models\VehicleGallery;
use Modules\Vehicle\app\Models\Vehicles;
use Modules\Vehicle\app\Models\VehicleType;
use Morilog\Jalali\Jalalian;

class VehicleController extends Controller
{
    public function vehicles()
    {
        $vehicles = Vehicles::with('galleries', 'user.profile', 'type', 'brand', 'category')->get();

        return Response()->success([
            'vehicles' => $vehicles,
        ],'', 200);
    }

    public function vehicle_information()
    {
        $vehicle_categories = VehicleCategory::where('state', 1)->get();
        $brands = VehicleBrand::where('state', 1)->get();
        $types = VehicleType::where('state', 1)->get();
        $vehicle_type = [
            [
                "value" => 0,
                "name" => 'اتوموبیل'
            ],
            [
                "value" => 1,
                "name" => 'موتور'
            ]
        ];

        return Response()->success([
            'vehicle_categories' => $vehicle_categories,
            'brands' => $brands,
            'types' => $types,
            'vehicle_type' => $vehicle_type,
        ],'', 200);
    }

    public function stor(Request $request)
    {
        print_r($request->all());
//        if (Auth::user()->state != 'accepted') {
//            return Response()->error('اطلاعات هویتی شما هنوز تایید نشده است',[],409);
//        }
//
//        $vehicleData = Vehicles::select(
//            'car_first_section_card_number',
//            'car_second_section_card_number',
//            'car_third_section_card_number',
//            'car_fourth_section_card_number',
//            'motor_card_number'
//        )->where('user_id', Auth::user()->id)->get();
//
//
//        if ($request->filled('motor_card_number')) {
//            $existingVehicle = Vehicles::where('motor_card_number', $request->motor_card_number)->first();
//            if ($existingVehicle)
//            {
//                return Response()->error('پلاک موتور تکراری است',[],409);
//            }
//        }
//        else
//        {
//            $existingVehicle = Vehicles::where('car_first_section_card_number', $request->plate_part4)
//                ->where('car_second_section_card_number', $request->plate_part3)
//                ->where('car_third_section_card_number', $request->plate_part2)
//                ->where('car_fourth_section_card_number', $request->plate_part1)
//                ->first();
//
//            if ($existingVehicle)
//            {
//                return Response()->error('پلاک اتوموبیل تکراری است',[],409);
//            }
//        }
//
//        $vehicle_card = File::uploadImage($request->vehicle_card, 'cars', $width = null, $height = null, $disk = 'secret');
//        $insurance = File::imageUpload($request->insurance, 'cars', $width = null, $height = null, $disk = 'secret');
//        $technical_examination = File::imageUpload($request->technical_examination, 'cars', $width = null, $height = null, $disk = 'secret');
//        $vehicle_front = File::imageUpload($request->vehicle_front, 'cars', $width = null, $height = null, $disk = 'secret');
//        $vehicle_back = File::imageUpload($request->vehicle_back, 'cars', $width = null, $height = null, $disk = 'secret');
//        $vehicle_right = File::imageUpload($request->vehicle_right, 'cars', $width = null, $height = null, $disk = 'secret');
//        $vehicle_left = File::imageUpload($request->vehicle_left, 'cars', $width = null, $height = null, $disk = 'secret');
//
//        $gregorianDate = Jalalian::fromFormat('Y-m-d', $request->insurance_date)->toCarbon()->toDateString();
//
//        $createVehicle = Vehicles::firstOrcreate([
//            'car_first_section_card_number' => $request->plate_part4,
//            'car_second_section_card_number' => $request->plate_part3,
//            'car_third_section_card_number' => $request->plate_part2,
//            'car_fourth_section_card_number' => $request->plate_part1,
//            'motor_card_number' => $request->motor_pelak,
//            'state' => 'pending',
//            'model_year' => $request->model_year,
//            'category_id' => $request->category_id,
//            'brand_id' => $request->brand_id,
//            'user_id' => Auth::user()->id,
//            'type_id' => $request->type_id,
//            'insurance_date' =>$gregorianDate,
//            'color' =>$request->color,
//        ]);
//
//        $createVehicleGallery = VehicleGallery::create([
//            'name' => 'vehicle_card',
//            'path_file' => $vehicle_card,
//            'vehicle_id' => $createVehicle->id,
//        ]);
//        $createVehicleGallery = VehicleGallery::create([
//            'name' => 'insurance',
//            'path_file' => $insurance,
//            'vehicle_id' => $createVehicle->id,
//        ]);
//        $createVehicleGallery = VehicleGallery::create([
//            'name' => 'technical_examination',
//            'path_file' => $technical_examination,
//            'vehicle_id' => $createVehicle->id,
//        ]);
//        $createVehicleGallery = VehicleGallery::create([
//            'name' => 'vehicle_front',
//            'path_file' => $vehicle_front,
//            'vehicle_id' => $createVehicle->id,
//        ]);
//        $createVehicleGallery = VehicleGallery::create([
//            'name' => 'vehicle_back',
//            'path_file' => $vehicle_back,
//            'vehicle_id' => $createVehicle->id,
//        ]);
//        $createVehicleGallery = VehicleGallery::create([
//            'name' => 'vehicle_right',
//            'path_file' => $vehicle_right,
//            'vehicle_id' => $createVehicle->id,
//        ]);
//        $createVehicleGallery = VehicleGallery::create([
//            'name' => 'vehicle_left',
//            'path_file' => $vehicle_left,
//            'vehicle_id' => $createVehicle->id,
//        ]);
//
//        return Response()->success([
//        ],'وسیله نقلیه با موفقیت ثبت شد و در انتظار تایید مدیر است', 200);
    }

    public function update(Request $request)
    {
        if (Auth::user()->state != 'accepted') {
            return Response()->error('اطلاعات هویتی شما هنوز تایید نشده است',[],409);
        }

        $old_vehicle = Vehicles::find($request->vehicle_id);
        $old_vehicle_galleries = VehicleGallery::where('vehicle_id', $request->vehicle_id)->get();

        $vehicle_card = $old_vehicle_galleries[0]->path_file;
        $insurance = $old_vehicle_galleries[1]->path_file;
        $technical_examination = $old_vehicle_galleries[2]->path_file;
        $vehicle_front = $old_vehicle_galleries[3]->path_file;
        $vehicle_back = $old_vehicle_galleries[4]->path_file;
        $vehicle_right = $old_vehicle_galleries[5]->path_file;
        $vehicle_left = $old_vehicle_galleries[6]->path_file;


        if (isset($request->vehicle_card))
        {
            $vehicle_card_delete = File::delete($vehicle_card, $disk = 'secret');
            $vehicle_card = File::uploadImage($request->vehicle_card, 'cars', $width = null, $height = null, $disk = 'secret');
            $updateVehicleGallery = VehicleGallery::where('name', 'vehicle_card')->where('vehicle_id', $old_vehicle->id)->update([
                'name' => 'vehicle_card',
                'path_file' => $vehicle_card,
                'vehicle_id' => $old_vehicle->id,
            ]);
        }
        if (isset($request->insurance))
        {
            $insurance_delete = File::delete($insurance, $disk = 'secret');
            $insurance = File::uploadImage($request->insurance, 'cars', $width = null, $height = null, $disk = 'secret');
            $updateVehicleGallery = VehicleGallery::where('name', 'insurance')->where('vehicle_id', $old_vehicle->id)->update([
                'name' => 'insurance',
                'path_file' => $insurance,
                'vehicle_id' => $old_vehicle->id,
            ]);
        }
        if (isset($request->technical_examination))
        {
            $technical_examination_delete = File::delete($technical_examination, $disk = 'secret');
            $technical_examination = File::uploadImage($request->technical_examination, 'cars', $width = null, $height = null, $disk = 'secret');
            $updateVehicleGallery = VehicleGallery::where('name', 'technical_examination')->where('vehicle_id', $old_vehicle->id)->update([
                'name' => 'technical_examination',
                'path_file' => $technical_examination,
                'vehicle_id' => $old_vehicle->id,
            ]);
        }
        if (isset($request->vehicle_front))
        {
            $vehicle_front_delete = File::delete($vehicle_front, $disk = 'secret');
            $vehicle_front = File::uploadImage($request->vehicle_front, 'cars', $width = null, $height = null, $disk = 'secret');
            $updateVehicleGallery = VehicleGallery::where('name', 'vehicle_front')->where('vehicle_id', $old_vehicle->id)->update([
                'name' => 'vehicle_front',
                'path_file' => $vehicle_front,
                'vehicle_id' => $old_vehicle->id,
            ]);
        }
        if (isset($request->vehicle_back))
        {
            $vehicle_back_delete = File::delete($vehicle_back, $disk = 'secret');
            $vehicle_back = File::uploadImage($request->vehicle_back, 'cars', $width = null, $height = null, $disk = 'secret');
            $updateVehicleGallery = VehicleGallery::where('name', 'vehicle_back')->where('vehicle_id', $old_vehicle->id)->update([
                'name' => 'vehicle_back',
                'path_file' => $vehicle_back,
                'vehicle_id' => $old_vehicle->id,
            ]);
        }
        if (isset($request->vehicle_right))
        {
            $vehicle_right_delete = File::delete($vehicle_right, $disk = 'secret');
            $vehicle_right = File::uploadImage($request->vehicle_right, 'cars', $width = null, $height = null, $disk = 'secret');
            $updateVehicleGallery = VehicleGallery::where('name', 'vehicle_right')->where('vehicle_id', $old_vehicle->id)->update([
                'name' => 'vehicle_right',
                'path_file' => $vehicle_right,
                'vehicle_id' => $old_vehicle->id,
            ]);
        }
        if (isset($request->vehicle_left))
        {
            $vehicle_left_delete = File::delete($vehicle_left, $disk = 'secret');
            $vehicle_left = File::uploadImage($request->vehicle_left, 'cars', $width = null, $height = null, $disk = 'secret');
            $updateVehicleGallery = VehicleGallery::where('name', 'vehicle_left')->where('vehicle_id', $old_vehicle->id)->update([
                'name' => 'vehicle_left',
                'path_file' => $vehicle_left,
                'vehicle_id' => $old_vehicle->id,
            ]);
        }

        $gregorianDate = Jalalian::fromFormat('Y-m-d', $request->insurance_date)->toCarbon()->toDateString();

        $UpdateVehicle = Vehicles::where('id', $request->vehicle_id)->update([
            'car_first_section_card_number' => $request->plate_part4,
            'car_second_section_card_number' => $request->plate_part3,
            'car_third_section_card_number' => $request->plate_part2,
            'car_fourth_section_card_number' => $request->plate_part1,
            'motor_card_number' => $request->motor_pelak,
            'state' => 'pending',
            'model_year' => $request->model_year,
            'category_id' => $request->category_id,
            'brand_id' => $request->brand_id,
            'user_id' => Auth::user()->id,
            'type_id' => $request->type_id,
            'color' => $request->color,
            'insurance_date' => $gregorianDate,
        ]);

        $Vehicle = Vehicles::find($request->vehicle_id);

        $Vehicle->notes()->create(
            [
                'note' => "وسیله نقلیه توسط کاربر ویرایش شد",
                'admin_id' => 0,
                'user_id' => Auth::user()->id,
                'state' => '0',
                'read' => '0',
            ]);
        return Response()->success([
        ],'وسیله نقلیه با موفقیت ویرایش شد و در انتظار تایید مدیر است', 200);
    }

    public function show_image($id)
    {
        $gallery = VehicleGallery::find($id);
        return Storage::disk('secret')->response($gallery->path_file);
    }
}
