<?php
Route::prefix('/v1')->as('api.v1.')->namespace('V1')->group(function(){
    Route::get('index','HomeController@index');
    Route::get('news/{id?}/{slug?}','HomeController@news');
    Route::get('show/news/{id}/{slug?}','HomeController@showNews');
    Route::get('competitions','HomeController@competition');
    Route::get('show/competition/{id}/{slug?}','HomeController@showCompetition');


    Route::namespace('Auth')->group(function(){

        Route::post('login', 'LoginController@login');
        Route::post('verify-code', 'LoginController@verifyCode');
        Route::post('set-password', 'LoginController@setPassword')->middleware(['auth:sanctum']);
        Route::post('login-by-password', 'LoginController@loginByPassword');
        Route::post('check-user','LoginController@checkUser')->middleware(['auth:sanctum']);
        Route::post('logout','LoginController@logout')->middleware(['auth:sanctum']);


        Route::match(['get'],'invalid-token','LoginController@invalid_token')->name('login');
        Route::post('forgot_password', 'ResetPasswordController@forget_password');
        Route::post('verify_reset_code', 'ResetPasswordController@verify_reset_code');
        Route::post('reset_password', 'ResetPasswordController@reset_password');


    });

    Route::group(['middleware' => 'auth:sanctum'], function () {
        Route::get('profile-detail','ProfileController@detail');
        Route::get('show-image/{id}','ProfileController@show_image');
        Route::post('profile','ProfileController@profile');
        Route::get('vehicles','VehicleController@vehicles');
        Route::get('vehicles-info','VehicleController@vehicle_information');
        Route::post('add-vehicle','VehicleController@stor');
        Route::post('update-vehicle','VehicleController@update');
        Route::get('show-vehicle-image/{id}','VehicleController@show_image');
        Route::post('add-comment','CommentController@add_comment');
        Route::get('messages','MessageController@messages');
        Route::post('read-message','MessageController@read_message');
    });

    Route::get('competition-categories','CompetitionController@category');
    Route::get('competition-prices','CompetitionController@prices');
    Route::get('site-setting','ContactUsController@site');
    Route::get('cities','ProfileController@city');
    Route::get('provinces','ProfileController@province');
    Route::get('majors','ProfileController@major');
    Route::get('positions','ProfileController@position');
    Route::get('educations','ProfileController@education');
    Route::get('show/menu/{name}','HomeController@showMenu');


});

