<?php
Route::prefix('/app/v1')->as('api.app.v1.')->namespace('App\V1')->group(function(){


    Route::namespace('Auth')->group(function(){
        Route::post('login', 'LoginController@login');
        Route::post('logout', 'LoginController@logout')->middleware(['auth:sanctum']);
        Route::post('check-user', 'LoginController@checkUser')->middleware(['auth:sanctum']);
    });

    Route::group(['middleware' => 'auth:sanctum'], function () {
        Route::get('/competitions','CompetitionController@competitions');
        Route::get('/show/competitions/{id}','CompetitionController@showCompetition');
        Route::post('/register/competition','CompetitionController@competitionRegister');
    });

});

