<?php

namespace Modules\Magazine\app\Http\Controllers\Dashboard\Frest;




use App\Http\Controllers\Controller;
use Barryvdh\DomPDF\Facade\Pdf;
use Carbon\Carbon;
use Illuminate\Support\Facades\Session;
use Modules\Magazine\app\Http\Requests\Dashboard\Frest\Magazine\MagazineStoreRequest;
use Modules\Magazine\app\Http\Requests\Dashboard\Frest\Magazine\MagazineUpdateRequest;
use Modules\Magazine\app\Models\Magazine;
use Modules\Magazine\app\Models\MagazineItem;


class MagazineController extends Controller
{


    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $this->authorize('magazine.access');
        $magazines = Magazine::latest()->paginate(15);

        return view('magazine::Dashboard.Frest.magazine.index',compact('magazines'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $this->authorize('magazine.create');
        $magazines = Magazine::latest()->get();
        return view('magazine::Dashboard.Frest.magazine.create',compact( 'magazines'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(MagazineStoreRequest $request)
    {

        $this->authorize('magazine.create');

        Magazine::create([
            'title' => $request->title,
            'note' => $request->note,
        ]);

        Session::flash('success','با موفقیت انجام شد');
        return redirect()->route('admin.magazine.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit(Magazine $magazine)
    {
        $this->authorize('magazine.edit');
        return view('magazine::Dashboard.Frest.magazine.edit',compact('magazine' ));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(MagazineUpdateRequest $request, Magazine $magazine)
    {
        $this->authorize('magazine.edit');

        $magazine->title = $request->title;
        $magazine->note = $request->note;
        $magazine->save();


        Session::flash('success','با موفقیت انجام شد');
        return redirect()->route('admin.magazine.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Magazine $magazine)
    {
        $this->authorize('magazine.delete');
        $magazine->delete();
        Session::flash('success','با موفقیت انجام شد');
        return redirect()->back();
    }

    public function createMagazinePdf($id)
    {
        $this->authorize('magazine.access');

        $magazine = Magazine::find($id);
        $items = MagazineItem::where('magazine_id',$magazine->id)->get();

        Pdf::setOption(['dpi' => 150]);
        $pdf = Pdf::loadView('magazine::Dashboard.Frest.Catalog.default', ['magazine' => $magazine,'items' => $items]);


        return $pdf->download('magazine.pdf');

        return view('magazine::Dashboard.Frest.Catalog.default',compact('magazine','items'));

    }




}
