<?php

namespace Modules\Magazine\app\Http\Controllers\Dashboard\Frest;



use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use Modules\Album\app\Models\Album;
use Modules\Category\app\Models\Category;
use Modules\Core\app\Http\Controllers\Helpers\File;
use Modules\Magazine\app\Http\Requests\Dashboard\Frest\Magazine\MagazineUpdateRequest;
use Modules\Magazine\app\Http\Requests\Dashboard\Frest\MagazineItem\MagazineItemStoreRequest;
use Modules\Magazine\app\Models\Magazine;
use Modules\Magazine\app\Models\MagazineItem;
use Modules\News\app\Models\News;
use Modules\Page\app\Models\Page;
use Modules\Product\app\Models\Color;
use Modules\Product\app\Models\Product;
use Modules\Product\app\Models\ProductColor;
use Modules\Product\app\Models\ProductMaterial;
use Modules\Video\app\Models\Video;

class MagazineItemController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index($id)
    {

        $magazine = Magazine::find($id);

        $items 	= MagazineItem::where('magazine_id',$magazine->id)->orderBy('order')->get();

        return view('magazine::Dashboard.Frest.magazine.item.index',compact('items','magazine'));

    }

    /**
     * Modify list of resource
     *
     * @param Request $request
     * @return \Illuminate\Http\Response
     */

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create($id)
    {
        $magazine = Magazine::find($id);

        $products = Product::latest()->get();

        return view('magazine::Dashboard.Frest.magazine.item.create',compact('magazine','products'));

    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(MagazineItemStoreRequest $request)
    {

        $path = File::uploadByFileManager($request->image);



        MagazineItem::create([
            'magazine_id' => $request->magazine_id,
            'image' => $path == null ? null : $path,
            'product_id' => $request->product_id,
            'color_fabric_id' => $request->color_fabric_id,
            'material_fabric_id' => $request->material_fabric_id,
            'color_body_id' => $request->color_body_id,
            'material_body_id' => $request->material_body_id,
            'note' => $request->note,
            'price' => $request->price,
            'price_partner' => $request->price_partner,
            'state' => $request->state,
            'order' =>  MagazineItem::max('order') + 1,
        ]);

        Session::flash('success','با موفقیت انجام شد');
        return redirect()->route('admin.magazine-item.list',$request->magazine_id);
    }


    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {

        $item = MagazineItem::find($id);
        $products = Product::latest()->get();

        $colors_fabric = ProductColor::where('product_id',$item->product_id)->get();
        $colors_body = ProductColor::where('product_id',$item->product_id)->get();
        $materials_fabric = ProductMaterial::where('product_id',$item->product_id)->get();
        $materials_body = ProductMaterial::where('product_id',$item->product_id)->get();


        return view('magazine::Dashboard.Frest.magazine.item.edit',compact('item',
            'colors_body','colors_fabric','materials_body','materials_fabric',
            'products'));
    }


    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(MagazineUpdateRequest $request,$id)
    {

        $item = MagazineItem::find($id);

        $path = File::uploadByFileManager($request->image);



           $item->image = $path == null ? null : $path;
           $item->product_id = $request->product_id;
           $item->color_fabric_id = $request->color_fabric_id;
           $item->material_fabric_id = $request->material_fabric_id;
           $item->color_body_id = $request->color_body_id;
           $item->material_body_id = $request->material_body_id;
           $item->note = $request->note;
           $item->price = $request->price;
           $item->price_partner = $request->price_partner;
           $item->state = $request->state;
           $item->update();



        Session::flash('success','با موفقیت انجام شد');
        return redirect()->route('admin.magazine-item.list',$item->magazine_id);

    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {

        $item = MagazineItem::find($id);
        $item->delete();

        Session::flash('success','با موفقیت انجام شد');
        return redirect()->back();



    }

    public function getColorBody(Request $request)
    {
        $data = '<option value="#">انتخاب کنید</option>';

        if ($request->ajax()) {
            $colors = ProductColor::where('product_id',$request->product_id)->get();
            foreach ($colors as $item){
                $data .= '<option value="'.$item->color_id.'" >'.$item->color->color_name.'</option>';
            }

            return response()->json($data);
        }

    }


    public function getColorFabric(Request $request)
    {
        $data = '<option value="#">انتخاب کنید</option>';

        if ($request->ajax()) {
            $colors = ProductColor::where('product_id',$request->product_id)->get();
            foreach ($colors as $item){
                $data .= '<option value="'.$item->color_id.'" >'.$item->color->color_name.'</option>';
            }

            return response()->json($data);
        }

    }

    public function getMaterialBody(Request $request)
    {
        $data = '<option value="#">انتخاب کنید</option>';

        if ($request->ajax()) {
            $colors = ProductMaterial::where('product_id',$request->product_id)->get();
            foreach ($colors as $item){
                $data .= '<option value="'.$item->material_id.'" >'.$item->material->material_name.'</option>';
            }

            return response()->json($data);
        }

    }

    public function getMaterialFabric(Request $request)
    {
        $data = '<option value="#">انتخاب کنید</option>';

        if ($request->ajax()) {
            $colors = ProductMaterial::where('product_id',$request->product_id)->get();
            foreach ($colors as $item){
                $data .= '<option value="'.$item->material_id.'" >'.$item->material->material_name.'</option>';
            }

            return response()->json($data);
        }

    }


    public function sortable(){

        foreach (Request()->orders as $index => $order){

            $item = MagazineItem::find($order);
            $item->order = $index;
            $item->update();

        }
    }
}
