<?php

namespace Modules\Magazine\app\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Modules\Product\app\Models\Color;
use Modules\Product\app\Models\Material;
use Modules\Product\app\Models\Product;

class MagazineItem extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     */
    protected $table = "magazine_items";
    protected $fillable = ['product_id','image','price','price_partner','order','magazine_id',
    'color_fabric_id','material_fabric_id','color_body_id','material_body_id','note','state'
    ];


    public function product(){
        return $this->belongsTo(Product::class,'product_id');
    }


    public function colorFabric(){
        return $this->belongsTo(Color::class,'color_fabric_id');
    }

    public function colorBody(){
        return $this->belongsTo(Color::class,'color_body_id');
    }

    public function materialBody(){
        return $this->belongsTo(Material::class,'material_body_id');
    }

    public function materialFabric(){
        return $this->belongsTo(Material::class,'material_fabric_id');
    }


}
