<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('magazine_items', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('product_id')->nullable();
            $table->unsignedBigInteger('color_fabric_id')->nullable();
            $table->unsignedBigInteger('material_fabric_id')->nullable();
            $table->unsignedBigInteger('color_body_id')->nullable();
            $table->unsignedBigInteger('material_body_id')->nullable();
            $table->unsignedBigInteger('magazine_id');
            $table->string('image')->nullable();
            $table->double('price')->default(0);
            $table->double('price_partner')->default(0);
            $table->integer('order')->default(0);
            $table->boolean('state')->default(0);
            $table->longText('note')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('magazine_items');
    }
};
