<!DOCTYPE html>
<html  lang="fa">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>{{$magazine->title}}</title>
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">

    <style>
        body{line-height: 2;word-spacing: 1px;}
        b{font-size: 90%;font-weight: lighter;}
        p{font-size: 100%;font-weight: bolder;}
        .card-box{border: 1px solid #999999;padding: 10px;margin-bottom: 10px;}
    </style>

</head>

<body>
<div class="container" style="padding: 10px;">

    <div class="row">
        <div class="col-12">
            <div class="card-box">


                <div class="table-responsive">
                    <table class="table table-hover mails m-0 table table-actions-bar">

                        <thead>
                        <tr>
                            <th>شناسه</th>
                            <th>نام محصول</th>
                            <th>نوع پارچه و رنگ</th>
                            <th>نوع بدنه و رنگ</th>
                            <th>قیمت فروش</th>
                            <th>قیمت همکار</th>
                        </tr>
                        </thead>

                        <tbody>
                        @foreach($items as $key => $item)
                            <tr>
                                <td>{{$item->id}}</td>
                                <td>{{$item->product->title}}</td>
                                <td>{{$item->materialFabric->material_name}} - {{$item->colorFabric->color_name}}</td>
                                <td>{{$item->materialBody->material_name}} - {{$item->colorBody->color_name}}</td>
                                <td>{{number_format($item->price)}}</td>
                                <td>{{number_format($item->partner_price)}}</td>
                            </tr>
                        @endforeach
                        </tbody>

                    </table>
                </div>
            </div>

        </div> <!-- end col -->


    </div>


</div>
</body>
<script src="{{ asset('print/jquery.min.js') }}"></script>
<script src="{{ asset('print/bootstrap-rtl.min.js') }}"></script>
</html>

