@extends('core::Dashboard.Frest.Layouts.master')

@section('title')
    لیست کاتالوگ ها
@endsection

@section('style')
@endsection

@section('script')

@endsection

@section('content')
    <div class="card" style="margin-bottom:15px; ">
        <p class="demo-inline-spacing">
            <button type="button" class="btn btn-icon me-2 btn-primary" type="button" data-bs-toggle="collapse"
                data-bs-target=".multi-collapse" aria-expanded="false"
                aria-controls="multiCollapseExample1 multiCollapseExample2">
                <i class="bx bx-search bx-sm"></i>
            </button>


        </p>

        <section>
            <div class="row">

                <div class="row">
                    <div class="col-12 col-md-12">
                        <div class="collapse multi-collapse" id="multiCollapseExample2">
                            <div class="col-md-12" style="padding: 0.8%;">
                                <form id="filter" action="{{route('admin.magazine.index')}}"
                                    method="get">
                                    <div class="row">
                                        <div class="col-md-2">
                                            <input type="text" id="q" name="q" class="form-control" placeholder="جستجو"
                                                value="{{ old('q') }}">
                                        </div>
                                        <div class="col-md-2">
                                            <button onclick="submitForm('filter')" name="filter" type="button"
                                                class="btn btn-primary me-1">جستجو</button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>



            </div>
        </section>
    </div>

    <div class="card">
        <form action="#" method="get">
            <p class="demo-inline-spacing">
                <a class="btn btn-primary me-1" href="{{ route('admin.magazine.create') }}" role="button"
                    aria-expanded="false">ایجاد کاتالوگ جدید</a>
            </p>
            <input type="text" id="items" name="items" value="" style="display: none;">
        </form>
            <h5 class="card-header">کاتالوگ ها</h5>
            <div class="table-responsive text-nowrap">
                <table class="table table-sm">
                    <thead>
                        <tr>
                            <th>
                                <div class="bulk-ids checkbox-primary m-r-15">
                                    <input id="bulk-ids" onClick="toggle(this)" type="checkbox">
                                    <label for="bulk-ids">#</label>
                                </div>
                            </th>
                            <th>عنوان</th>
                            <th>عملیات</th>
                        </tr>
                    </thead>
                    <tbody>

                        @foreach ($magazines as $magazine)
                            <tr>
                                <th>
                                    <div class="bulk-ids checkbox-primary m-r-15">
                                        <input id="bulk-ids" onClick="syncItems(this)" name="ids[]"value="{{$magazine->id}}" type="checkbox">
                                        <label for="bulk-ids"></label>
                                    </div>
                                </th>
                                <td> {{$magazine->title}}</td>

                                <td>
                                    <div class="dropdown">
                                        <button type="button" class="btn p-0 dropdown-toggle hide-arrow" data-bs-toggle="dropdown"><i class="bx bx-dots-vertical-rounded"></i></button>
                                        <div class="dropdown-menu">
                                            <a class="dropdown-item" href="/admin/magazine/items/{{$magazine->id}}"><i class="bx bx-edit-alt me-1"></i>لیستم آیتم ها</a>
                                            <a class="dropdown-item" href="/admin/create/magazine/pdf/{{$magazine->id}}"><i class="bx bx-download-alt me-1"></i>ساخت فایل پی دی اف</a>
                                            <a class="dropdown-item" href="{{ route('admin.magazine.edit' ,$magazine->id) }}"><i class="bx bx-edit-alt me-1"></i>ویرایش</a>


                                            <button class="dropdown-item" onclick="event.preventDefault();confirmDelete('delete-{{$magazine->id}}')"><i class="bx bx-trash me-1"></i>حذف</button>
                                            <form id="delete-{{$magazine->id}}" action="{{ route('admin.magazine.destroy', $magazine->id) }}" method="POST" style="display: none;">
                                                {{ csrf_field() }}
                                                {{ method_field('DELETE') }}
                                            </form>
                                        </div>
                                    </div>
                                </td>
                            </tr>
                        @endforeach

                    </tbody>
                </table>

                <div style="margin-top: 10%;">
                    {{ $magazines->render() }}
                </div>
            </div>



    </div>
@endsection
