@extends('core::Dashboard.Frest.Layouts.master')

@section('title')
لیست محصولات کاتالوگ
@endsection

@section('style')

@endsection

@section('script')
    <script src="{{asset('modules/core/vendor/libs/sortablejs/sortable.js')}}"></script>
    <script src="https://cdn.jsdelivr.net/npm/axios/dist/axios.min.js"></script>
    <script>

        const cloneSource1 = document.getElementById('clone-source-1');


        Sortable.create(cloneSource1, {
            animation: 150,
            group: {
                name: 'cloneList',
                pull: 'clone',
                revertClone: true
            },
            onUpdate: function (evt) {
                const list = [];
                const orders = document.getElementsByName('orders[]');
                for (var i = 0; i < orders.length; i++) {
                    var item = orders[i];
                    list.push(item.value);
                }


                axios.post('/admin/magazine-item/sortable', {
                    orders: list,
                })
                    .then(function (response) {
                        Swal.fire({
                            title: 'موفق',
                            text: 'با موفقیت انجام شد',
                            icon: 'success'
                        })
                    })
                    .catch(function (error) {
                        Swal.fire({
                            title: 'خطا',
                            text: 'خطایی رخ داده است',
                            icon: 'error'
                        })
                    });

            },
        });


    </script>
@endsection

@section('content')
    <div class="card" style="margin-bottom:15px; ">

        <p class="demo-inline-spacing">
            <button type="button" class="btn btn-icon me-2 btn-primary" data-bs-toggle="collapse"
                    data-bs-target=".multi-collapse" aria-expanded="false"
                    aria-controls="multiCollapseExample1 multiCollapseExample2">
                <i class="bx bx-search bx-sm"></i>
            </button>


        </p>

        <section>
            <div class="row">

                <div class="row">
                    <div class="col-12 col-md-12">
                        <div class="collapse multi-collapse" id="multiCollapseExample2">
                            <div class="col-md-12" style="padding: 0.8%;">
                                <form id="filter" action="{{route('admin.magazine-item.index')}}"
                                      method="get">
                                    <div class="row">
                                        <div class="col-md-2">
                                            <input type="text" id="q" name="q" class="form-control" placeholder="جستجو"
                                                   value="{{ old('q') }}">
                                        </div>
                                        <div class="col-md-2">
                                            <button onclick="submitForm('filter')" name="filter" type="button"
                                                    class="btn btn-primary me-1">جستجو
                                            </button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>


            </div>
        </section>
    </div>


    <div class="card">
        <form action="{{ route('admin.bulk.magazineItems') }}" method="get">

            <p class="demo-inline-spacing">
                    <a class="btn btn-primary me-1" href="/admin/magazine-item/create/{{$magazine->id}}" role="button"
                       aria-expanded="false">جدید</a>
                <button name="publish" type="submit" class="btn btn-success me-1">انتشار</button>
                <button name="unPublish" type="submit" class="btn btn-gray me-1">غیر انتشار</button>
                <button name="delete" type="submit" class="btn btn-danger me-1">حذف</button>
            </p>
            <input type="text" id="items" name="items" value="" style="display: none;">
        </form>
        <div class="row">
            <div class="col-md-12 col-12 mb-md-0 mb-4">
                @if(count($items) > 0)
                    <ul class="list-group list-group-flush" id="clone-source-1">
                        @foreach($items as $item)
                            @include('magazine::Dashboard.Frest.magazine.item.listMenuItemsTable',['item' => $item ,'class' => ''])
                        @endforeach
                    </ul>
                @else
                    <div class="alert alert-danger">
                        آیتمی ثبت نشده است
                    </div>
                @endif
            </div>
        </div>


    </div>
@endsection
