<?php




    Route::as('admin.')->prefix('admin')->namespace('Dashboard\Frest')->middleware('auth:admin','check_role_admin')->group(function(){

        Route::get('create/magazine/pdf/{id}','MagazineController@createMagazinePdf')->name('magazine.create.pdf');
        Route::Resource('magazine','MagazineController');
        Route::Resource('magazine-item','MagazineItemController');
        Route::get('magazine-item.modify','MagazineItemController@modify')->name('magazine-item.modify');
        Route::get('magazine/items/{id}','MagazineItemController@index')->name('magazine-item.list');
        Route::get('magazine-item/create/{id}','MagazineItemController@create')->name('get.magazine-item.create');
        Route::post('magazine-item/sortable','MagazineItemController@sortable');
        Route::post('magazine-item.color.body','MagazineItemController@getColorBody')->name('get-color-body');
        Route::post('magazine-item.color.fabric','MagazineItemController@getColorFabric')->name('get-color-fabric');
        Route::post('magazine-item.material.body','MagazineItemController@getMaterialBody')->name('get-material-body');
        Route::post('magazine-item.material.fabric','MagazineItemController@getMaterialFabric')->name('get-material-fabric');




        Route::as('bulk.')->prefix('/bulk')->group(function (){
            Route::get('/magazine','MagazineItem@bulkAction')->name('magazine');
            Route::get('/magazineitems','MagazineItemController@bulkAction')->name('magazineItems');
        });
    });



