<?php

namespace Modules\Menu\app\Http\Controllers\Dashboard\Frest;




use App\Http\Controllers\Controller;
use Carbon\Carbon;
use Illuminate\Support\Facades\Session;
use Modules\Menu\app\Models\Menu;
use Modules\Menu\app\Http\Requests\Dashboard\Frest\Menu\MenuStoreRequest;
use Modules\Menu\app\Http\Requests\Dashboard\Frest\Menu\MenuUpdateRequest;

class MenuController extends Controller
{


    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $this->authorize('menu.access');
        $menus = Menu::latest()->paginate(15);

        return view('menu::Dashboard.Frest.menu.index',compact('menus'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $this->authorize('menu.create');
        $menus = Menu::latest()->get();
        return view('menu::Dashboard.Frest.menu.create',compact( 'menus'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(MenuStoreRequest $request)
    {

        $this->authorize('menu.create');

        Menu::create([
            'title' => $request->title,
            'name' => $request->name,
            'desc' => $request->desc,
            'state' => $request->state,
        ]);

        Session::flash('success','با موفقیت انجام شد');
        return redirect()->route('admin.menu.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit(Menu $menu)
    {
        $this->authorize('menu.edit');
        return view('menu::Dashboard.Frest.menu.edit',compact('menu' ));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(MenuUpdateRequest $request, Menu $menu)
    {
        $this->authorize('menu.edit');

        $menu->title = $request->title;
        $menu->name = $request->name;
        $menu->desc =  $request->desc;
        $menu->state = $request->state;
        $menu->save();


        Session::flash('success','با موفقیت انجام شد');
        return redirect()->route('admin.menu.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Menu $menu)
    {
        $this->authorize('menu.delete');
        $menu->delete();
        Session::flash('success','با موفقیت انجام شد');
        return redirect()->back();
    }


    public function bulkAction()
    {

        $items = [];
        $items = explode(',',Request()->items);


        if(isset($_GET['delete']))
        {
            $this->authorize('menu.delete');
            Menu::whereIn('id',$items)->delete();
        }
        if (isset($_GET['unPublish']))
        {
            $this->authorize('menu.edit');
            Menu::whereIn('id',$items)->update([
                'state' => 0
            ]);
        }
        if(isset($_GET['publish']))
        {
            $this->authorize('menu.edit');
            Menu::whereIn('id',$items)->update([
                'state' => 1
            ]);
        }

        if(isset($_GET['clone']))
        {
            $this->authorize('menu.edit');
            $menus = Menu::whereIn('id',$items)->get();

            foreach ($menus as $index =>  $menu){
                $newMenu = $menu->replicate();
                $newMenu->title = $newMenu->title . ' ' .Carbon::now();
                $newMenu->name = $newMenu->name . ' ' .Carbon::now();
                $newMenu->created_at = Carbon::now();
                $newMenu->save();

                foreach ($menu->items as $item){
                    $newItem = $item->replicate();
                    $newItem->title = $item->title;
                    $newItem->menu_id = $newMenu->id;
                    $newItem->created_at = Carbon::now();
                    $newItem->save();
                }
            }
        }



        session::flash('success','با موفقیت انجام شد');
        return redirect()->back();

    }
}
