<?php

namespace Modules\Menu\app\Http\Controllers\Dashboard\Frest;



use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Session;
use Modules\Album\app\Models\Album;
use Modules\Category\app\Models\Category;
use Modules\Core\app\Http\Controllers\Helpers\File;
use Modules\Menu\app\Models\Menu;
use Modules\Menu\app\Models\Menuitem;
use Modules\Menu\app\Http\Requests\Dashboard\Frest\Menu\MenuUpdateRequest;
use Modules\Menu\app\Http\Requests\Dashboard\Frest\MenuItem\MenuItemStoreRequest;
use Modules\News\app\Models\News;
use Modules\Page\app\Models\Page;
use Modules\Portfolio\app\Models\Portfolio;
use Modules\Portfolio\app\Models\PortfolioCategory;
use Modules\Product\app\Models\Product;
use Modules\Video\app\Models\Video;

class MenuitemController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index($id)
    {

        $menu = Menu::find($id);

        $items 	= Menuitem::
             when(Request()->parent_id == null ,function ($query){
               return $query->whereNull('parent_id');
             })
            ->when(Request()->parent_id != null ,function ($query){
                return $query->where('parent_id',Request()->parent_id);
            })
            ->whereMenu_id($menu->id)->orderBy('order')->get();

        return view('menu::Dashboard.Frest.menu.item.index',compact('items','menu'));

    }

    /**
     * Modify list of resource
     *
     * @param Request $request
     * @return \Illuminate\Http\Response
     */

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create($id)
    {
        $menu = Menu::find($id);

        $parents = Menuitem::whereNull('parent_id')
            ->whereMenu_id($menu->id)
            ->with('children')->get();




        return view('menu::Dashboard.Frest.menu.item.create',compact('parents','menu'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(MenuItemStoreRequest $request)
    {

        $link = null;
        if($request->type == 'custom' && $request->custom != null){
            $link = $request->custom;
        }

        if($request->type != 'custom' && $request->link != '#'){
            $link = $request->link;
        }

        if($request->type == 'file') {
            $link = $request->file;
        }

        $path = File::uploadByFileManager($request->image);

        $parent = Menuitem::find($request->parent_id);

        Menuitem::create([
            'title' => $request->title,
            'type' => $request->type,
            'class_css' => $request->class_css,
            'link' => $request->type == 'custom' ? $request->custom : $request->link,
            'menu_id' => $request->menu_id,
            'image' => $path == null ? null : $path,
            'target' => $request->target,
            'order' => $request->parent_id == null ? Menuitem::max('order')+1 : Menuitem::whereParent_id($parent->id)->max('order') + 1 ,
            'desc' => $request->desc,
            'parent_id' => $request->parent_id == null ? null : $parent->id,
            'state' => $request->state,
            'item_id' => $request->item_id,
            'item_type' => $request->item_type,
            'type_view' => $request->type_view,
            'file' => $request->file,
            'special' => $request->special,
        ]);

        Session::flash('success','با موفقیت انجام شد');
        return redirect()->route('admin.menuitem.list',$request->menu_id);
    }


    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {

        $item = Menuitem::find($id);

        $parents = Menuitem::whereNull('parent_id')->whereMenu_id($item->menu_id)
            ->where('id','!=',$item->id)
            ->with('children')->get();


        $links = $item->links();




        return view('menu::Dashboard.Frest.menu.item.edit',compact('parents','item','links'));
    }


    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(MenuUpdateRequest $request,$id)
    {

        $item = Menuitem::find($id);

        $link = null;
        if($request->type == 'custom' && $request->custom != null) {
            $link = $request->custom;
        }

        if($request->type != 'custom' && $request->link != '#') {
            $link = $request->link;
        }

        if($request->type == 'file') {
            $link = $request->file;
        }

        $path = File::uploadByFileManager($request->image);

        $parent = Menuitem::find($request->parent_id);

        $item->title = $request->title;
        $item->type = $request->type;
        $item->class_css = $request->class_css;
        $item->link = $link != null ? $link : $item->link;
        $item->target = $request->target;
        $item->image = $path == null ? $item->image : $path ;
        $item->desc = $request->desc;
        $item->order = $request->parent_id == null ? $item->order : Menuitem::whereParent_id($parent->id)->max('order') + 1 ;
        $item->class_css = $request->class_css;
        $item->parent_id = $request->parent_id == null ? null : $parent->id;
        $item->state = $request->state;
        $item->item_id = $request->item_id;
        $item->item_type = $request->item_type;
        $item->type_view = $request->type_view;
        $item->file = $request->file;
        $item->special = $request->special;
        $item->save();



        Session::flash('success','با موفقیت انجام شد');
        return redirect()->route('admin.menuitem.list',$item->menu_id);

    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {

        $item = Menuitem::find($id);

        $items = Menuitem::where('parent_id', $item->id)->get()->each(function($item)

        {
            $item->parent_id = 0;
            $item->save();
        });

        $item->delete();


        Session::flash('success','با موفقیت انجام شد');
        return redirect()->back();



    }

    public function getMenu(Request $request)
    {
        $data = '<option value="#">انتخاب کنید</option>';

        if ($request->ajax()) {
            switch ($request->type)
            {
                case 'news':
                    $links = News::whereState(1)->latest()->get();
                    foreach ($links as $item){
                        $data .= '<option data-id="'.$item->id.'" data-type="'.get_class($item).'" value="'.$item->route.'">'.$item->title.'</option>';
                    }
                    break;
                case 'category-news':
                    $links = Category::whereType('news')->whereState(1)->latest()->get();
                    foreach ($links as $item){
                        $data .= '<option data-id="'.$item->id.'" data-type="'.get_class($item).'" value="'.$item->route.'">'.$item->title.'</option>';
                    }
                    break;
                case 'albums':
                    $links = Album::whereState(1)->latest()->get();
                    foreach ($links as $item){
                        $data .= '<option data-id="'.$item->id.'" data-type="'.get_class($item).'" value="'.$item->route.'">'.$item->title.'</option>';
                    }
                    break;
                case 'category-albums':
                    $links = Category::whereType('albums')->whereState(1)->latest()->get();
                    foreach ($links as $item){
                        $data .= '<option data-id="'.$item->id.'" data-type="'.get_class($item).'" value="'.$item->route.'">'.$item->title.'</option>';
                    }
                    break;
                case 'videos':
                    $links = Video::whereState(1)->latest()->get();
                    foreach ($links as $item){
                        $data .= '<option data-id="'.$item->id.'" data-type="'.get_class($item).'" value="'.$item->route.'">'.$item->title.'</option>';
                    }
                    break;
                case 'category-videos':
                    $links = Category::whereType('videos')->whereState(1)->latest()->get();
                    foreach ($links as $item){
                        $data .= '<option data-id="'.$item->id.'" data-type="'.get_class($item).'" value="'.$item->route.'">'.$item->title.'</option>';
                    }
                    break;
                case 'products':
                    $links = Product::whereState(1)->latest()->get();
                    foreach ($links as $item){
                        $data .= '<option data-id="'.$item->id.'" data-type="'.get_class($item).'" value="'.$item->route.'">'.$item->title.'</option>';
                    }
                    break;
                case 'category-products':
                    $links = Category::whereType('products')->whereState(1)->latest()->get();
                    foreach ($links as $item){
                        $data .= '<option data-id="'.$item->id.'" data-type="'.get_class($item).'" value="'.$item->route.'">'.$item->title.'</option>';
                    }

                case 'portfolios':
                    $links = Portfolio::latest()->get();
                    foreach ($links as $item){
                        $data .= '<option data-id="'.$item->id.'" data-type="'.get_class($item).'" value="'.$item->route.'">'.$item->title.'</option>';
                    }
                    break;
                case 'category-portfolios':
                    $links = PortfolioCategory::latest()->get();
                    foreach ($links as $item){
                        $data .= '<option data-id="'.$item->id.'" data-type="'.get_class($item).'" value="'.$item->route.'">'.$item->title.'</option>';
                    }
                    break;
                case 'page':
                    $links = Page::whereState(1)->latest()->get();
                    foreach ($links as $item){
                        $data .= '<option data-id="'.$item->id.'" data-type="'.get_class($item).'" value="'.$item->route.'">'.$item->title.'</option>';
                    }
                    break;
                case 'custom':
                    $links = 'custom';
                    break;
                default:
                    $links = 'custom';
                    break;
            }

            return response()->json($data);
        }


    }


    public function bulkAction()
    {

        $items = [];
        $items = explode(',',Request()->items);


        if(isset($_GET['delete']))
        {
            $this->authorize('type.delete');
            Menuitem::whereIn('id',$items)->delete();
        }
        if (isset($_GET['unPublish']))
        {
            $this->authorize('type.edit');
            Menuitem::whereIn('id',$items)->update([
                'state' => 0
            ]);
        }
        if(isset($_GET['publish']))
        {
            $this->authorize('type.edit');
            Menuitem::whereIn('id',$items)->update([
                'state' => 1
            ]);
        }



        session::flash('success','با موفقیت انجام شد');
        return redirect()->back();

    }

    public function sortable(){

        foreach (Request()->orders as $index => $order){

            $item = Menuitem::find($order);
            $item->order = $index;
            $item->update();

        }
    }
}
