<?php

namespace Modules\Menu\app\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Menu extends Model
{
    use SoftDeletes;
    protected $fillable = ['title','name','desc','state'];



    public function items(){
        return $this->hasMany(Menuitem::class,'menu_id');
    }

    public function itemsActive(){
        return $this->hasMany(Menuitem::class,'menu_id')->where('state',"=",1)->where('parent_id',"=",null)->orderBy('order');
    }
}

