<?php

namespace Modules\Menu\app\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Modules\Album\app\Models\Album;
use Modules\Category\app\Models\Category;
use Modules\News\app\Models\News;
use Modules\Page\app\Models\Page;
use Modules\Portfolio\app\Models\Portfolio;
use Modules\Portfolio\app\Models\PortfolioCategory;
use Modules\Product\app\Models\Product;
use Modules\Video\app\Models\Video;

class Menuitem extends Model
{
    use SoftDeletes;

    protected $fillable = [
        'title',
        'type',
        'link',
        'file',
        'image',
        'target',
        'state',
        'special',
        'order',
        'class_css',
        'desc',
        'menu_id',
        'item_id',
        'item_type',
        'type_view',
        'parent_id'];


    public function menu(){
        return $this->belongsTo(Menu::class,'menu_id');
    }

    public function item()
    {
        return $this->morphTo('item','item_type','item_id');
    }


    public function parent(){
        return $this->belongsTo(Menuitem::class,'parent_id');
    }

    public function children(){
        return $this->hasMany(Menuitem::class,'parent_id');
    }

    public function childrenActive(){
        return $this->hasMany(Menuitem::class,'parent_id')->where('state',1)->orderBy('order');
    }

    public function childrenSpecialActive(){
        return $this->hasMany(Menuitem::class,'parent_id')->where('state',1)->where('special',1)->orderBy('order');
    }

    public function buildMenu($menu, $parentid = null)
    {
        $result = null;

        foreach ($menu as $item){
            if ($item->parent_id == $parentid) {
                $result .= "<li class='dd-item nested-list-item' data-order='{$item->order}' data-id='{$item->id}'>
				<div class='dd-handle nested-list-handle'>
					<span class='glyphicon glyphicon-move'></span>
					  <div class='bulk-ids checkbox-primary m-r-15'>
                                        <input id='bulk-ids' name='items[]' value='{{$item->id}}' type='checkbox'>
                                        <label for='bulk-ids'></label>
                                        <span>{$item->title}</span>


                                        	<div class='row nested-list-content'>
					<div class='pull-right text-right m-r-5'>
						<form method='POST' action='".route('admin.menuitem.destroy',$item)."'>
							<input name ='_token' type='hidden' value='".csrf_token()."'>
							<input type='hidden' name='_method' value='DELETE'>

							<a class='btn btn-sm btn-info text-info' href='".route('admin.menuitem.edit',$item->id)."'>
								<span class='fa fa-edit'></span>
							</a>
							<button class='btn btn-sm text-danger btn-danger m-r-5 m-l-5' type='submit' rel='{$item->id}'>
								<span class='fa fa-trash'></span>
							</button>

						</form>
					</div>
				    </div>



                       </div>





				</div>

				"
                    .$this->buildMenu($menu, $item->id)."</li>";
            }
        }

        return $result ?  "\n<ol class=\"dd-list\">\n$result</ol>\n" : null;
    }

    // Getter for the HTML menu builder
    public function getHTML($items)
    {
        return $this->buildMenu($items);
    }

    public function buildMainMenu($menu,$depth=null){
        $result = null;
        foreach ($menu as $item){
            if($item->children->isNotEmpty()){
                if(empty($depth)){
                    $result.='
							<li class="nav-item dropdown">
								<a class="nav-link" title="'.htmlentities($item->title).'" href="'.$item->title.'" data-toggle="dropdown">
								   '.htmlentities($item->title).'
								   <span class="tw-indicator"><i class="fa fa-angle-down"></i></span>
								</a>
							';
                    $result.='<ul class="dropdown-menu">'.$this->buildMainMenu($item->children,1).'</ul>';
                }else{
                    $result.='
							<li class="dropdown">
								<a class="" title="'.htmlentities($item->title).'" href="'.$item->title.'">
								   '.htmlentities($item->title).'
								</a>
							';
                    $result.='<ul class="dropdown-menu">'.$this->buildMainMenu($item->children,1).'</ul>';
                }
                $result.='</li>';
            }else{
                if($item->parent){
                    $result.='<li><a class="dropdown-item" title="'.htmlentities($item->title).'" href="'.$item->title.'">'.htmlentities($item->title).'</a></li>';
                }else{
                    $result.='
					<li class="nav-item '.(request()->is($item->title) ? 'active' : null ).'">
						<a class="nav-link" title="'.htmlentities($item->title).'" href="'.$item->title.'">
						   '.htmlentities($item->title).'
						</a>
					</li>
				';
                }
            }
        }


        return $result;
    }

    //Getter for the HTML menu builder in main page
    public function getMainMenu($items){
        $htmlMenu=$this->buildMainMenu($items);
        if(!empty($htmlMenu)){
            return '<ul class="navbar-nav">'.$htmlMenu.'</ul>';
        }
    }


    public function getImageUrlAttribute($value){

        return  $this->image;

    }


    public function getRouteAttribute()
    {
        return $this->link;
    }


    public function links(){
        $links = [];
        switch ($this->type)
        {
            case 'news':
                $links = News::whereState(1)->latest()->get();
                break;
            case 'category-news':
                $links = Category::whereType('news')->whereState(1)->latest()->get();
                break;
            case 'albums':
                $links = Album::whereState(1)->latest()->get();
                break;
            case 'category-albums':
                $links = Category::whereType('albums')->whereState(1)->latest()->get();
                break;
            case 'videos':
                $links = Video::whereState(1)->latest()->get();
                break;
            case 'category-videos':
                $links = Category::whereType('videos')->whereState(1)->latest()->get();
                break;
            case 'products':
                $links = Product::whereState(1)->latest()->get();
                break;
            case 'category-products':
                $links = Category::whereType('products')->whereState(1)->latest()->get();
                break;
            case 'portfolios':
                $links = Portfolio::latest()->get();
                break;
            case 'category-portfolios':
                $links = PortfolioCategory::latest()->get();
                break;
            case 'page':
                $links = Page::whereState(1)->latest()->get();
                break;
            case 'custom':
                $links = 'custom';
                break;
            default:
                $links = 'custom';
                break;
        }

        return $links;
    }


}
