<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateMenuitemsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('menuitems', function (Blueprint $table) {
            $table->id();

            $table->string('title');
            $table->string('type')->nullable();
            $table->string('link')->nullable();
            $table->string('image')->nullable();
            $table->string('target')->default('_parent');
            $table->boolean('state')->default(0);
            $table->boolean('special')->default(0);
            $table->integer('order')->default(0);
            $table->string('class_css')->nullable();

            $table->text('desc')->nullable();

            $table->unsignedBigInteger('menu_id')->references('id')->on('menus')->onDelete('cascade');
            $table->unsignedBigInteger('parent_id')->nullable()->references('id')->on('menus')->onDelete('cascade');

            $table->unsignedBigInteger('admin_id')->nullable();
            $table->foreign('admin_id')->references('id')->on('admins')->onDelete('set null');

            $table->softDeletes();
            $table->timestamps();

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('menuitems');
    }
}
