@extends('core::Dashboard.Frest.Layouts.master')

@section('title')
    داشبورد
@endsection

@section('style')
@endsection

@section('script')

@endsection

@section('content')
    <div class="row">
        <div class="col">
            <h6 class="mt-4 secondary-font"> ویرایش </h6>
            <div class="card mb-3">
                <div class="card-header border-bottom primary-font">
                    <ul class="nav nav-tabs card-header-tabs" role="tablist">
                        <li class="nav-item">
                            <button class="nav-link active" data-bs-toggle="tab" data-bs-target="#tab1" role="tab"
                                aria-selected="true">
                                اطلاعات
                            </button>
                        </li>
                    </ul>
                </div>

                <div class="tab-content">
                    <div class="tab-pane fade active show" id="tab1" role="tabpanel">
                        <form action="{{ route('admin.menu.update', $menu->id) }}" method="post">
                            @csrf
                            @method('put')


                            <div class="row g-3">

                                <div class="col-md-8">

                                    <div class="row">

                                        <div class="col-md-6">
                                            <span>*</span>
                                            <label class="form-label" for="title">عنوان</label>
                                            <input type="text" id="title" name="title" class="form-control"
                                                placeholder="عنوان" value="{{ $menu->title, old('title') }}">
                                            @if ($errors->has('title'))
                                                <div data-field="title" class="text-danger">
                                                    {{ $errors->first('title') }}</div>
                                            @endif
                                        </div>

                                        <div class="col-md-6">
                                            <span>*</span>
                                            <label class="form-label" for="name">کلید</label>
                                            <input type="text" id="name" name="name" class="form-control"
                                                   placeholder="کلید" value="{{ $menu->name, old('name') }}">
                                            @if ($errors->has('name'))
                                                <div data-field="name" class="text-danger">
                                                    {{ $errors->first('name') }}</div>
                                            @endif
                                        </div>



                                        <div class="col-md-12">
                                            <label class="form-label" for="desc">توضیحات</label>
                                            <textarea type="text" id="desc" name="desc" class="form-control">{{ $menu->desc, old('desc') }}</textarea>
                                            @if ($errors->has('desc'))
                                                <div data-field="desc" class="text-danger">{{ $errors->first('desc') }}
                                                </div>
                                            @endif
                                        </div>

                                    </div>

                                </div>

                                <div class="col-md-4">

                                     <div class="col-md-12">
                                        <span>*</span>
                                        <label class="form-label" for="state">وضعیت</label>
                                        <div class="position-relative">
                                            <select id="state" name="state" class="form-select">
                                                <option value="">انتخاب</option>
                                                <option value="1" {{ '1' == $menu->state ? 'selected' : '' }}>فعال</option>
                                                <option value="0" {{ '0' == $menu->state ? 'selected' : '' }}>غیر فعال
                                                </option>
                                            </select>
                                        </div>
                                    </div>

                

                                </div>



                            </div>
                            <div class="pt-4">
                                <button type="submit" class="btn btn-primary me-sm-3 me-1">ثبت</button>
                                <a href="{{ route('admin.menu.index') }}"
                                    class="btn btn-label-secondary">انصراف</a>
                            </div>
                        </form>
                    </div>

                </div>
            </div>
        </div>
    </div>
@endsection
