@extends('core::Dashboard.Frest.Layouts.master')

@section('title')
    منو ساز
@endsection

@section('style')
@endsection

@section('script')

@endsection

@section('content')
    <div class="card" style="margin-bottom:15px; ">
        <p class="demo-inline-spacing">
            <button type="button" class="btn btn-icon me-2 btn-primary" type="button" data-bs-toggle="collapse"
                data-bs-target=".multi-collapse" aria-expanded="false"
                aria-controls="multiCollapseExample1 multiCollapseExample2">
                <i class="bx bx-search bx-sm"></i>
            </button>


        </p>

        <section>
            <div class="row">

                <div class="row">
                    <div class="col-12 col-md-12">
                        <div class="collapse multi-collapse" id="multiCollapseExample2">
                            <div class="col-md-12" style="padding: 0.8%;">
                                <form id="filter" action="{{route('admin.category.index')}}"
                                    method="get">
                                    <div class="row">
                                        <div class="col-md-2">
                                            <input type="text" id="q" name="q" class="form-control" placeholder="جستجو"
                                                value="{{ old('q') }}">
                                        </div>
                                        <div class="col-md-2">
                                            <button onclick="submitForm('filter')" name="filter" type="button"
                                                class="btn btn-primary me-1">جستجو</button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>



            </div>
        </section>
    </div>


    <div class="card">
        <form action="{{ route('admin.bulk.menus') }}" method="get">
            <p class="demo-inline-spacing">
                <a class="btn btn-primary me-1" href="{{ route('admin.menu.create') }}" role="button"
                    aria-expanded="false">جدید</a>
                <button name="publish" type="submit" class="btn btn-success me-1">انتشار</button>
                <button name="unPublish" type="submit" class="btn btn-gray me-1">غیر انتشار</button>
                <button name="delete" type="submit" class="btn btn-danger me-1">حذف</button>
                <button name="clone" type="submit" class="btn btn-warning me-1"  >رونوشت</button>
            </p>
            <input type="text" id="items" name="items" value="" style="display: none;">
        </form>
            <h5 class="card-header">منو های سایت</h5>
            <div class="table-responsive text-nowrap">
                <table class="table table-sm">
                    <thead>
                        <tr>
                            <th>
                                <div class="bulk-ids checkbox-primary m-r-15">
                                    <input id="bulk-ids" onClick="toggle(this)" type="checkbox">
                                    <label for="bulk-ids">#</label>
                                </div>
                            </th>
                            <th>عنوان</th>
                            <th>وضعیت</th>
                            <th>عملیات</th>
                        </tr>
                    </thead>
                    <tbody>

                        @foreach ($menus as $menu)
                            <tr>
                                <th>
                                    <div class="bulk-ids checkbox-primary m-r-15">
                                        <input id="bulk-ids" onClick="syncItems(this)" name="ids[]"value="{{$menu->id}}" type="checkbox">
                                        <label for="bulk-ids"></label>
                                    </div>
                                </th>
                                <td> {{$menu->title}}<span class="badge badge-success"> {{$menu->name}}</span></td>
                                @if($menu->state == 1)
                                    <td><span class="badge bg-label-success me-1">فعال</span></td>
                                @endif
                                @if($menu->state == 0)
                                    <td><span class="badge bg-label-danger me-1">غیرفعال</span></td>
                                @endif

                                <td>
                                    <div class="dropdown">
                                        <button type="button" class="btn p-0 dropdown-toggle hide-arrow" data-bs-toggle="dropdown"><i class="bx bx-dots-vertical-rounded"></i></button>
                                        <div class="dropdown-menu">
                                            <a class="dropdown-item" href="/admin/menu/items/{{$menu->id}}"><i class="bx bx-edit-alt me-1"></i>لیستم آیتم ها</a>
                                            <a class="dropdown-item" href="{{ route('admin.menu.edit' ,$menu->id) }}"><i class="bx bx-edit-alt me-1"></i>ویرایش</a>


                                            <button class="dropdown-item" onclick="event.preventDefault();confirmDelete('delete-{{$menu->id}}')"><i class="bx bx-trash me-1"></i>حذف</button>
                                            <form id="delete-{{$menu->id}}" action="{{ route('admin.menu.destroy', $menu->id) }}" method="POST" style="display: none;">
                                                {{ csrf_field() }}
                                                {{ method_field('DELETE') }}
                                            </form>
                                        </div>
                                    </div>
                                </td>
                            </tr>
                        @endforeach

                    </tbody>
                </table>

                <div style="margin-top: 10%;">
                    {{ $menus->render() }}
                </div>
            </div>



    </div>
@endsection
