@extends('core::Dashboard.Frest.Layouts.master')

@section('title')ایجاد@endsection

    @section('style')

        @endsection

    @section('script')

        <script type="text/javascript">

            $(".link").show();
            $(".custom").hide();
            $("select[name='type']").change(function(){
                var type = $(this).val();
                var token = $("input[name='_token']").val();

                $.ajax({
                    url: "<?php echo route('admin.get-menu') ?>",
                    method: 'POST',
                    data: {type:type,_token:token},
                    success: function(data) {
                        $("select[name='link']").html(data);
                        $('.selectpicker_oncreate').selectpicker('refresh');
                    }
                });

                if( type == 'custom'){
                    $(".link").hide();
                    $(".custom").show();
                }
                if( type != 'custom'){
                    $(".link").show();
                    $(".custom").hide();
                }

            });


            $("select[name='link']").change(function(){

                if( type == 'custom'){
                    $("input[name='item_id']").val($(this).find("option:selected").attr('data-id'));
                    $("input[name='item_type']").val($(this).find("option:selected").attr('data-type'));
                }

                if( type != 'custom'){
                    $("input[name='item_id']").val($(this).find("option:selected").attr('data-id'));
                    $("input[name='item_type']").val($(this).find("option:selected").attr('data-type'));
                }

            });

        </script>

    @endsection

@section('content')


    <div class="row">
        <div class="col">
            <h6 class="mt-4 secondary-font">ایجاد</h6>
            <div class="card mb-3">
                <div class="card-header border-bottom primary-font">
                    <ul class="nav nav-tabs card-header-tabs" role="tablist">
                        <li class="nav-item">
                            <button class="nav-link active" data-bs-toggle="tab" data-bs-target="#tab1" role="tab" aria-selected="true">
                               اطلاعات
                            </button>
                        </li>
                    </ul>
                </div>

                <div class="tab-content">
                    <div class="tab-pane fade active show" id="tab1" role="tabpanel">
                        <form action="{{route('admin.menuitem.store')}}" method="post">
                            {{ csrf_field() }}
                            <input value="{{$menu->id}}" name="menu_id" style="display: none;">

                            <div class="row g-3">

                                <div class="col-md-8">

                                    <div class="row">

                                        <div class="col-md-6">
                                            <span>*</span>
                                            <label class="form-label" for="title">عنوان</label>
                                            <input type="text" id="title"  name="title" class="form-control" placeholder="عنوان" value="{{old('title')}}">
                                            @if($errors->has('title'))
                                                <div data-field="title" class="text-danger">{{ $errors->first('title') }}</div>
                                            @endif
                                        </div>

                                        <div class="col-md-6">
                                            <span>*</span>
                                            <label class="form-label" for="type">نوع منو</label>
                                            <div class="position-relative">
                                                <select id="type" name="type" class="form-select" >
                                                     <option value="#">انتخاب کنید</option>
                                                    <option value="news" {{'news' == old('type') ? 'selected' : ''}} >خبر</option>
                                                    <option value="category-news" {{'category-news' == old('type') ? 'selected' : ''}} >مجموعه بلاگ اخبار</option>
                                                    <option value="albums" {{'albums' == old('type') ? 'selected' : ''}} >آلبوم</option>
                                                    <option value="category-albums" {{'category-albums' == old('type') ? 'selected' : ''}} >مجموعه بلاگ آلبوم</option>

                                                    <option value="videos" {{'videos' == old('type') ? 'selected' : ''}} >ویدئو ها</option>
                                                    <option value="category-videos" {{'category-videos' == old('type') ? 'selected' : ''}} >مجموعه بلاگ ویدئو ها</option>

                                                    <option value="products" {{'products' == old('type') ? 'selected' : ''}} >محصولات</option>
                                                    <option value="category-products" {{'category-products' == old('type') ? 'selected' : ''}} >مجموعه بلاگ محصولات</option>

                                                    <option value="portfolios" {{'portfolios' == old('type') ? 'selected' : ''}} >نمونه کارها</option>
                                                    <option value="category-portfolios" {{'category-portfolios' == old('type') ? 'selected' : ''}} >نمونه کارها دسته بندی</option>


                                                    <option value="page" {{'page' == old('type') ? 'selected' : ''}} >صفحات</option>
                                                    <option value="file" {{'file' == old('type') ? 'selected' : ''}} >فایل</option>

                                                    <option value="custom" {{'custom' == old('type') ? 'selected' : ''}} >دلخواه</option>


                                                    <option value="menus" {{'menus' == old('type') ? 'selected' : ''}} >زیر منو ها</option>
                                                </select>
                                            </div>
                                        </div>




                                        <div class="form-group col-md-12 link {{ $errors->has('link') ? 'has-errors' : '' }}">
                                            <label for="field-2" class="control-label">لینک</label>
                                            <select  name="link"   class="form-control" id="field-2"  aria-hidden="true" data-live-search="true" >
                                                <option value="">انتخاب کنید</option>
                                            </select>
                                            @if($errors->has('link'))
                                                <span class="help-doc text-danger">
                                                    <strong>{{ $errors->first('link') }}</strong>
                                                </span>
                                            @endif
                                            <input name="item_id" value="" style="display:none">
                                            <input name="item_type" value="" style="display:none">
                                        </div>

                                        <div class="col-md-12 custom">
                                            <div class="form-group {{ $errors->has('custom') ? 'has-errors' : '' }}">
                                                <label for="field-1" class="control-label">لینک دلخواه</label>
                                                <input type="text" name="custom"  class="form-control" id="field-1" placeholder="لینک دلخواه" value="{{old('custom')}}">
                                                @if($errors->has('custom'))
                                                    <span class="help-doc text-danger">
                                                        <strong>{{ $errors->first('custom') }}</strong>
                                                   </span>
                                                @endif
                                            </div>
                                        </div>



                                        <div class="col-md-12">
                                            <label class="form-label" for="desc">توضیحات</label>
                                            <textarea type="text" id="desc"  name="desc" class="form-control" >{{old('desc')}}</textarea>
                                            @if($errors->has('desc'))
                                                <div data-field="desc" class="text-danger">{{ $errors->first('desc') }}</div>
                                            @endif
                                        </div>


                                    </div>

                                </div>

                                <div class="col-md-4">

                                    <div class="col-md-12">
                                        <label class="form-label" for="title">تصویر</label>
                                        <div class="input-group">
                                            <input type="text" id="image1" class="form-control" name="image"
                                                   aria-label="Image" aria-describedby="button-image">
                                            <div class="input-group-append">
                                                <button class="btn btn-outline-secondary" type="button" id="button-image">آپلود</button>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-md-12">
                                        <label class="form-label" for="title">فایل</label>
                                        <div class="input-group">
                                            <input type="text" id="image-2" class="form-control" name="file"
                                                   aria-label="Image" aria-describedby="button-image-2">
                                            <div class="input-group-append">
                                                <button class="btn btn-outline-secondary" type="button" id="button-image-2">آپلود</button>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-12 mb-10">
                                        <label for="selectpickerSelectDeselect" class="form-label">والد</label>
                                        <select style="display: none" id="selectpickerSelectDeselect" name="parent_id" class="selectpicker w-100" data-style="btn-default" data-actions-box="true" data-live-search="true">
                                                <option value="">والد رو انتخاب کنید</option>
                                            @foreach($parents as $parent)
                                                @include('menu::Dashboard.Frest.menu.item.listPerntsMenu',['parent' => $parent,'parent_id' => Request()->parent_id])
                                            @endforeach
                                        </select>
                                    </div>


                                    <div class="col-md-12">
                                        <span>*</span>
                                        <label class="form-label" for="class_css">کلاس استایل</label>
                                        <input type="text" id="class_css"  name="class_css" class="form-control" placeholder="عنوان" value="{{old('class_css')}}">
                                        @if($errors->has('class_css'))
                                            <div data-field="class_css" class="text-danger">{{ $errors->first('class_css') }}</div>
                                        @endif
                                    </div>

                                    <div class="col-md-12">
                                        <span>*</span>
                                        <label class="form-label" for="target">نوع لینک</label>
                                        <div class="position-relative">
                                            <select id="target" name="target" class="form-select" >
                                                <option value="_parent" {{'_parent' == old('target') ? 'selected' : ''}}>در همان صفحه</option>
                                                <option value="_blank" {{'_blank' == old('target') ? 'selected' : ''}}>صفحه جدید</option>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="col-md-12">
                                        <span>*</span>
                                        <label class="form-label" for="state">وضعیت</label>
                                        <div class="position-relative">
                                            <select id="state" name="state" class="form-select" >
                                                <option value="1" {{'1' == old('state') ? 'selected' : ''}}>فعال</option>
                                                <option value="0" {{'0' == old('state') ? 'selected' : ''}}>غیر فعال</option>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="col-md-12">
                                        <span>*</span>
                                        <label class="form-label" for="special">ویژه</label>
                                        <div class="position-relative">
                                            <select id="special" name="special" class="form-select" >
                                                <option value="0" {{'0' == old('special') ? 'selected' : ''}}>غیر ویژه</option>
                                                <option value="1" {{'1' == old('special') ? 'selected' : ''}}>ویژه</option>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="col-md-12">
                                        <span>*</span>
                                        <label class="form-label" for="target">نوع نمایش صفحه</label>
                                        <div class="position-relative">
                                            <select id="type_view" name="type_view" class="form-select" >
                                                <option value="default" {{'default' == old('type_view') ? 'selected' : ''}}>پیش فرض</option>
                                                <option value="box" {{'box' == old('type_view') ? 'selected' : ''}}>بصورت باکس</option>
                                                <option value="list" {{'list' == old('type_view') ? 'selected' : ''}}>بصورت لیست</option>
                                            </select>
                                        </div>
                                    </div>



                                </div>



                            </div>
                            <div class="pt-4">
                                <button type="submit" class="btn btn-primary me-sm-3 me-1">ثبت</button>
                                <a href="/admin/menu/items/{{$menu->id}}" type="reset" class="btn btn-label-secondary">انصراف</a>
                            </div>
                        </form>
                    </div>

                </div>
            </div>
        </div>
    </div>




@endsection
