@extends('core::Dashboard.Frest.Layouts.master')

@section('title')داشبورد@endsection

    @section('style')

        @endsection

    @section('script')


        <script type="text/javascript">
            @if($links !='custom')
            $(".custom").hide();
            $(".link").show();
            @else
            $(".custom").show();
            $(".link").hide();
            @endif
            $("select[name='type']").change(function(){
                var type = $(this).val();
                var token = $("input[name='_token']").val();

                $.ajax({
                    url: "<?php echo route('admin.get-menu') ?>",
                    method: 'POST',
                    data: {type:type,_token:token},
                    success: function(data) {
                        $("select[name='link']").html(data);
                        $('.selectpicker_oncreate').selectpicker('refresh');
                    }
                });

                if( type == 'custom' || type =='#'){
                    $(".link").hide();
                    $(".custom").show();
                }
                if( type != 'custom' || type =='#'){
                    $(".link").show();
                    $(".custom").hide();
                }

            });

            $("select[name='link']").change(function(){

                if( type == 'custom'){
                    $("input[name='item_id']").val($(this).find("option:selected").attr('data-id'));
                    $("input[name='item_type']").val($(this).find("option:selected").attr('data-type'));
                }

                if( type != 'custom'){
                    $("input[name='item_id']").val($(this).find("option:selected").attr('data-id'));
                    $("input[name='item_type']").val($(this).find("option:selected").attr('data-type'));
                }

            });

        </script>


    @endsection

@section('content')


    <div class="row">
        <div class="col">
            <h6 class="mt-4 secondary-font">ویرایش</h6>
            <div class="card mb-3">
                <div class="card-header border-bottom primary-font">
                    <ul class="nav nav-tabs card-header-tabs" role="tablist">
                        <li class="nav-item">
                            <button class="nav-link active" data-bs-toggle="tab" data-bs-target="#tab1" role="tab" aria-selected="true">
                               اطلاعات
                            </button>
                        </li>
                    </ul>
                </div>

                <div class="tab-content">
                    <div class="tab-pane fade active show" id="tab1" role="tabpanel">
                        <form action="{{route('admin.menuitem.update',$item->id)}}" method="post">
                            {{ csrf_field() }}
                            @method('PUT')

                            <div class="row g-3">

                                <div class="col-md-8">

                                    <div class="row">

                                        <div class="col-md-6">
                                            <span>*</span>
                                            <label class="form-label" for="title">عنوان</label>
                                            <input type="text" id="title"  name="title" class="form-control" placeholder="عنوان" value="{{$item->title}}">
                                            @if($errors->has('title'))
                                                <div data-field="title" class="text-danger">{{ $errors->first('title') }}</div>
                                            @endif
                                        </div>

                                        <div class="col-md-6">
                                            <span>*</span>
                                            <label class="form-label" for="type">نوع منو</label>
                                            <div class="position-relative">
                                                <select id="type" name="type" class="form-select" >
                                                    <option value="#">انتخاب کنید</option>
                                                    <option value="news" {{'news' == $item->type ? 'selected' : ''}} >خبر</option>
                                                    <option value="category-news" {{'category-news' == $item->type ? 'selected' : ''}} >مجموعه بلاگ اخبار</option>

                                                    <option value="videos" {{'videos' == $item->type ? 'selected' : ''}} >ویدئو ها</option>
                                                    <option value="category-videos" {{'category-videos' == $item->type ? 'selected' : ''}} >مجموعه بلاگ ویدئو</option>

                                                    <option value="albums" {{'albums' == $item->type ? 'selected' : ''}} >آلبوم ها</option>
                                                    <option value="category-albums" {{'category-albums' == $item->type ? 'selected' : ''}} >مجموعه بلاگ آلبوم</option>

                                                    <option value="products" {{'products' == $item->type ? 'selected' : ''}} >محصولات</option>
                                                    <option value="category-products" {{'category-products' == $item->type ? 'selected' : ''}} >مجموعه بلاگ محصولات</option>

                                                    <option value="portfolios" {{'portfolios' == $item->type  ? 'selected' : ''}} >نمونه کارها</option>
                                                    <option value="category-portfolios" {{'category-portfolios' == $item->type  ? 'selected' : ''}} >نمونه کارها دسته بندی</option>


                                                    <option value="page" {{'page' == $item->type ? 'selected' : ''}} >صفحات</option>
                                                    <option value="file" {{'file' == $item->type ? 'selected' : ''}} >فایل</option>
                                                    <option value="custom" {{'custom' == $item->type ? 'selected' : ''}} >دلخواه</option>

                                                    <option value="menus" {{'menus' == old('type') ? 'selected' : ''}} >زیر منو ها</option>
                                                </select>
                                            </div>
                                        </div>



                                        <div class="form-group  col-md-12 link {{ $errors->has('link') ? 'has-errors' : '' }}">
                                            <label for="field-2" class="control-label">لینک</label>
                                            <select  name="link"  class="form-control  selectpicker_oncreate" id="field-2"  aria-hidden="true" data-live-search="true" >
                                                <option value="">انتخاب کنید</option>
                                                @if($links != 'custom')
                                                    @foreach($links as $link)
                                                        <option value="{{$link->route}}" {{$link->route == $item->link ? 'selected' : ' '}}>{{$link->title}}</option>
                                                    @endforeach
                                                @endif
                                            </select>
                                            @if($errors->has('link'))
                                                <span class="help-doc text-danger">
                                        <strong>{{ $errors->first('link') }}</strong>
                                    </span>
                                            @endif
                                            <input name="item_id" value="" style="display:none">
                                            <input name="item_type" value="" style="display:none">
                                        </div>

                                        <div class="col-md-12 custom {{ $errors->has('custom') ? 'has-errors' : '' }}">
                                            <div class="form-group">
                                                <label for="field-1" class="control-label">لینک دلخواه</label>
                                                <input type="text" name="custom"  class="form-control" id="field-1" placeholder="لینک دلخواه" value="{{old('custom',$item->link)}}">
                                                @if($errors->has('custom'))
                                                    <span class="help-doc text-danger">
                                        <strong>{{ $errors->first('custom') }}</strong>
                                    </span>
                                                @endif
                                            </div>
                                        </div>



                                        <div class="col-md-12">
                                            <label class="form-label" for="desc">توضیحات</label>
                                            <textarea type="text" id="desc"  name="desc" class="form-control" >{{$item->desc}}</textarea>
                                            @if($errors->has('desc'))
                                                <div data-field="desc" class="text-danger">{{ $errors->first('desc') }}</div>
                                            @endif
                                        </div>


                                    </div>

                                </div>

                                <div class="col-md-4">

                                    <div class="col-md-12">
                                        <label class="form-label" for="title">تصویر</label>
                                        <div class="input-group">
                                            <input type="text" id="image1" class="form-control" name="image"
                                                   aria-label="Image" aria-describedby="button-image">
                                            <div class="input-group-append">
                                                <button class="btn btn-outline-secondary" type="button" id="button-image">آپلود</button>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-md-12">
                                        <label class="form-label" for="title">فایل</label>
                                        <div class="input-group">
                                            <input type="text" id="image-2" class="form-control" name="file"
                                                   aria-label="Image" aria-describedby="button-image-2" value="{{$item->file}}">
                                            <div class="input-group-append">
                                                <button class="btn btn-outline-secondary" type="button" id="button-image-2">آپلود</button>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-12 mb-10">
                                        <label for="selectpickerSelectDeselect" class="form-label">والد</label>
                                        <select style="display: none" id="selectpickerSelectDeselect" name="parent_id" class="selectpicker w-100" data-style="btn-default" data-actions-box="true" data-live-search="true">
                                            <option value="">والد رو انتخاب کنید</option>
                                            @foreach($parents as $parent)
                                                @include('menu::Dashboard.Frest.menu.item.listPerntsMenu',['parent' => $parent ,'parent_id' => $item->parent_id])
                                            @endforeach
                                        </select>
                                    </div>


                                    <div class="col-md-12">
                                        <span>*</span>
                                        <label class="form-label" for="class_css">کلاس استایل</label>
                                        <input type="text" id="class_css"  name="class_css" class="form-control" placeholder="عنوان" value="{{$item->class_css}}">
                                        @if($errors->has('class_css'))
                                            <div data-field="class_css" class="text-danger">{{ $errors->first('class_css') }}</div>
                                        @endif
                                    </div>

                                    <div class="col-md-12">
                                        <span>*</span>
                                        <label class="form-label" for="target">نوع لینک</label>
                                        <div class="position-relative">
                                            <select id="target" name="target" class="form-select" >
                                                <option value="" >انتخاب</option>
                                                <option value="_blank" {{'_blank' == $item->target ? 'selected' : ''}}>صفحه جدید</option>
                                                <option value="_parent" {{'_parent' == $item->target ? 'selected' : ''}}>در همان صفحه</option>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="col-md-12">
                                        <span>*</span>
                                        <label class="form-label" for="state">وضعیت</label>
                                        <div class="position-relative">
                                            <select id="state" name="state" class="form-select" >
                                                <option value="" >انتخاب</option>
                                                <option value="1" {{'1' == $item->state ? 'selected' : ''}}>فعال</option>
                                                <option value="0" {{'0' == $item->state ? 'selected' : ''}}>غیر فعال</option>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="col-md-12">
                                        <span>*</span>
                                        <label class="form-label" for="special">ویژه</label>
                                        <div class="position-relative">
                                            <select id="special" name="special" class="form-select" >
                                                <option value="" >انتخاب</option>
                                                <option value="1" {{'1' == $item->special ? 'selected' : ''}}>ویژه</option>
                                                <option value="0" {{'0' == $item->special ? 'selected' : ''}}>غیر ویژه</option>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="col-md-12">
                                        <span>*</span>
                                        <label class="form-label" for="target">نوع نمایش صفحه</label>
                                        <div class="position-relative">
                                            <select id="type_view" name="type_view" class="form-select" >
                                                <option value="default" {{'default' == $item->type_view ? 'selected' : ''}}>پیش فرض</option>
                                                <option value="box" {{'box' == $item->type_view ? 'selected' : ''}}>بصورت باکس</option>
                                                <option value="list" {{'list' == $item->type_view ? 'selected' : ''}}>بصورت لیست</option>
                                            </select>
                                        </div>
                                    </div>



                                </div>



                            </div>
                            <div class="pt-4">
                                <button type="submit" class="btn btn-primary me-sm-3 me-1">ثبت</button>
                                <a href="/admin/menu/items/{{$item->menu_id}}" type="reset" class="btn btn-label-secondary">انصراف</a>
                            </div>
                        </form>
                    </div>

                </div>
            </div>
        </div>
    </div>




@endsection
