<?php

namespace Modules\Migration\app\Http\Controllers\Dashboard\Frest;



use App\Http\Controllers\Controller;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Modules\Admin\app\Models\Admin;
use Modules\Category\app\Models\Category;
use Modules\Comment\app\Models\Comment;
use Modules\Core\app\Http\Controllers\Helpers\Str;
use Modules\News\app\Models\News;
use Modules\Product\app\Models\Product;
use Modules\Role\app\Models\Role;


class MigrationController extends Controller
{

    public static function getCategory()
    {

        $categories = DB::connection('migration')
            ->table('usbrj_categories')->orderBy('id','DESC')->chunk(100, function($categories){

                foreach ($categories as $category){

                    $duplicate = Category::where('key',$category->alias)->first();

                    Category::firstOrCreate(
                        ['id' => $category->id],
                        [
                            'id' => $category->id,
                            'title' => $category->title,
                            'type' => 'news',
                            'key'  => $duplicate != null ? $category->alias . " ({$category->id})" : $category->alias,
                            'state' => $category->published
                        ]);

                }

            });



    }


    public static function syncCategory()
    {

        $categories = DB::connection('migration')
            ->table('usbrj_categories')->orderBy('id','DESC')->chunk(100, function($categories){


                foreach ($categories as $category) {
                    $category_new = Category::find($category->id);
                    $parent = Category::find($category->parent_id);
                    if($category->parent_id != 0 && $parent != null){
                        $category_new->parent_id = $parent->id;
                        $category_new->update();
                    }

                    $roles = Role::latest()->pluck('id')->toArray();
                    $category_new->roles()->attach($roles);

                }

            });



    }

    public static function getAdmin()
    {
        $admins = DB::connection('migration')
            ->table('usbrj_users')->orderBy('id','DESC')->chunk(100, function($admins){

                foreach ($admins as $item){

                    Admin::firstOrCreate(
                        ['id' => $item->id],
                        [
                            'id' => $item->id,
                            'name' => $item->name,
                            'family' => $item->name,
                            'email' => $item->email,
                            'username' => $item->username,
                            'password'  => $item->password,
                            'state' => $item->block != 1 ? 1 : 0,
                            'send_email' => $item->sendEmail,
                            'send_sms' => 0,
                        ]);
                }



            });



    }

    public static function getPosts()
    {

        $latest = News::latest('id')->first();

        $pointer = $latest != null ? $latest->id : 0;
        try {

            $news = DB::connection('migration')
                ->table('usbrj_content')->
                where('id', '>' ,$pointer)->orderBy('id','asc')->chunk(100, function($news){


                    foreach ($news as $item){


                        $admin = Admin::find($item->created_by);


                        $images = json_decode($item->images);

                        $category = Category::find($item->catid);

                        $newItem =  News::firstOrCreate(['id' => $item->id],
                            [
                                'id' => $item->id,
                                'title' => $item->title,
                                'title_little' => $item->title_little,
                                'lead' => $item->introtext,
                                'body' => $item->fulltext,

                                'state' => $item->state,
                                'cat_id' => $category != null ? $category->id : null,
                                'admin_id' => $admin ? $item->created_by : null,
                            ]);







//                            $newItem->publish_down =  Str::isValidTimeStamp($item->publish_down, '0000-00-00 00:00:00') == true ? $item->publish_down : null  ;
//                            $newItem->publish_up = Str::isValidTimeStamp($item->publish_up ,'0000-00-00 00:00:00') == true  ? $item->publish_up :  null;
//                            $newItem->created_at = Str::isValidTimeStamp($item->created,null) == true ? $item->created : null;
//                            $newItem->updated_at = Str::isValidTimeStamp($item->modified,null) == true ? $item->modified : null;
//                            $newItem->update();



                    }




                });



            return 'done';

        }catch (\Exception $e) {

            DB::rollback();
            Log::channel('ErrorFetch')->info($e->getMessage() . ' *** ' . $e->getLine() . ' *** ' . $e->getCode());
            dd($e->getMessage());
        }


    }

    public function syncImagesBody(){

        try {

            $news = News::latest()->chunk(1000, function($news){


                    foreach ($news as $item) {
                        $images = json_decode($item->images);
                        $body = str_replace('src="storage/images/' , 'src="/storage/images/',$item->body);
                        $item->body = $body;
                        $item->update();
                    }




                });




            return response()->success($news, 'با موفقیت انجام شد');

        }catch (\Exception $e) {

            DB::rollback();
            Log::channel('ErrorFetch')->info($e->getMessage() . ' *** ' . $e->getLine() . ' *** ' . $e->getCode());
            dd($e);
        }
    }


    public static function syncNews()
    {

        try {

            $news = News::where('image1',null)->orderBy('id','asc')->chunk(1000, function($news){


                    foreach ($news as $item){

                        $old_news = DB::connection('migration')
                            ->table('usbrj_content')->where('id',$item->id)->first();


                        $images = json_decode($old_news->images);

                        $item->image1 = isset($images->image_intro) ? $images->image_intro : null;


                        $item->publish_down =  Str::isValidTimeStamp($item->publish_down, '0000-00-00 00:00:00') == true ? $item->publish_down : null  ;
                        $item->publish_up = Str::isValidTimeStamp($item->publish_up ,'0000-00-00 00:00:00') == true  ? $item->publish_up :  null;
                        $item->created_at = Str::isValidTimeStamp($item->created,null) == true ? $item->created : null;
                        $item->updated_at = Str::isValidTimeStamp($item->modified,null) == true ? $item->modified : null;
                        $item->update();



                    }




                });




           return 'ok0';

        }catch (\Exception $e) {

            Log::channel('ErrorFetch')->info($e->getMessage() . ' *** ' . $e->getLine() . ' *** ' . $e->getCode());
            dd($e->getMessage());
        }


    }

    public function syncSlugPost(){

        try {

            $news = News::latest()->chunk(1000, function($news){


                foreach ($news as $item) {

                    $title = $item->title;
                    $item->title = $title;
                    $item->update();
                }




            });




            return response()->success($news, 'با موفقیت انجام شد');

        }catch (\Exception $e) {

            DB::rollback();
            Log::channel('ErrorFetch')->info($e->getMessage() . ' *** ' . $e->getLine() . ' *** ' . $e->getCode());
            dd($e);
        }
    }

    public static function getComments()
    {
        $comments = DB::connection('migration')
            ->table('usbrj_jcomments')->get();

        foreach ($comments as $comment) {

            $newComments = Comment::firstOrCreate(
                [
                    'id' => $comment->id,
                ],

                [

                    'id' => $comment->id,
                    'commentable_id' => $comment->object_id,
                    'name' => $comment->name,
                    'email' => $comment->email,
                    'ip' => $comment->ip,
                    'commentable_type' => 'App\Model\News',
                    'body' => $comment->comment,
                    'state' => $comment->published == 1 ? 1 : 0 ,
                    'created_at' =>$comment->date

                ]
            );

        }




    }

    public static function syncComments()
    {
        $comments = DB::connection('migration')
            ->table('usbrj_jcomments')->get();

        foreach ($comments as $comment) {
           $comment_new = Comment::find($comment->id);
            $parent = Comment::find($comment->parent);
           if($comment->parent != 0 && $parent != null){
               $comment_new->parent_id = $parent->id;
               $comment_new->update();
           }

        }




    }



    public function syncSlugs(){

        $categories = Category::latest()->get();

        foreach ($categories as $category) {
            $category->slug = Str::slug($category->title);
            $category->update();
        }


        $news = News::latest()->get();

        foreach ($news as $item) {
            $item->slug = Str::slug($item->title);
            $item->update();
        }


        $products = Product::latest()->get();

        foreach ($products as $product) {
            $product->slug = Str::slug($product->title);
            $product->update();
        }


    }

}

