<?php

namespace Modules\News\app\Http\Controllers\Dashboard\Frest;




use App\Http\Controllers\Controller;
use Barryvdh\DomPDF\Facade\Pdf;
use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Session;
use Maatwebsite\Excel\Facades\Excel;
use Modules\Category\app\Models\Category;
use Modules\Core\app\Http\Controllers\Helpers\File;
use Modules\Core\app\Http\Controllers\Helpers\Str;
use Modules\Field\app\Traits\FieldCustom;
use Modules\News\app\Models\News;
use Modules\News\app\Models\Source;
use Modules\News\app\Models\Type;
use Modules\News\app\Http\Requests\Dashboard\Frest\News\NewsStoreRequest;
use Modules\News\app\Http\Requests\Dashboard\Frest\News\NewsUpdateRequest;
use Modules\NovinHub\Http\Helpers\NovinHub;
use Modules\Service\app\Models\Service;
use Modules\Service\app\Models\ServiceModel;
use Modules\Tag\app\Models\Tag;


class NewsController extends Controller
{
    use FieldCustom;
    public function index()
    {


        $this->authorize('news.access');

        $types = Type::latest()->get();
        $sources = Source::latest()->get();


        $user = Auth::guard('admin')->user();


        $categories = Category::whereState(1)->whereType('news')->whereHas('roles', function ($query)  use ($user) {
            $query->whereIn('id',$user->roles->pluck('role_id'));
        })->get();


        $query = News::
            when(Request()->tran_id != null,function ($query){
                $query->where('tran_id',Request()->tran_id);
            })
            ->when(Request()->tran_id == null,function ($query){
                $query->where('tran_id',null);
            })->
            when(!is_null(Request()->q),function ($query){
                return $query->where('title','LIKE','%'.Request()->q."%")
                ->orWhere('id','LIKE','%'.Request()->q."%");
            })
             ->when(!is_null(Request()->source_id),function ($query){
                 return $query->whereIn('source_id',Request()->source_id);
             })
            ->when(!is_null(Request()->type_id),function ($query){
                return $query->whereIn('type_id',Request()->type_id);
            })
            ->when(!is_null(Request()->cat_id),function ($query){
                return $query->whereIn('cat_id',Request()->cat_id);
            })
            ->when(!is_null(Request()->state),function ($query){
                return $query->whereIn('state',Request()->state);
            })
            ->when(!is_null(Request()->special),function ($query){
                return $query->whereIn('special',Request()->special);
            })
            ->when(!is_null(Request()->categories),function ($query){
                return $query->whereHas('categories',function ($query){
                    $query->whereIn('id',Request()->categories);
                });
            })

            ->when(!is_null(Request()->start_date), function ($query) {
                $start_date = Str::convertToGregorian(Request()->start_date . ':00');
                return $query->whereDate('created_at','>=',$start_date);
            })
            ->when(!is_null(Request()->end_date), function ($query)  {
                $end_date = Str::convertToGregorian(Request()->end_date . ':00');
                return $query->whereDate('created_at','<=',$end_date);
            })
            ->with('user','categories','category')
            ->latest('id');





        if(isset($_GET['print'])){
            $news = $query->limit(200)->get();
            return view('template.print.news' , compact('news'));
        }

        if(isset($_GET['pdf'])){
            $news = $query->limit(200)->get();
            Pdf::setOption(['dpi' => 150, 'defaultFont' => 'sans-serif']);
            $pdf = Pdf::loadView('template.print.news', ['news' => $news]);
            return $pdf->download('news.pdf');
        }

        if (isset($_GET['excel'])) {
            $items = $query->latest()->get();
            return Excel::download(new NewsExport($items),'news.xlsx');
        }

        $news = $query->paginate(15);

        return view('news::Dashboard.Frest.news.index' , compact('news','types','sources','categories'));


    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $this->authorize('news.create');

        $trans = News::where('tran_id',Request()->tran_id)
            ->orWhere('id',Request()->tran_id)->pluck('lang')->toArray();

        $watermarks = [];

        $user = Auth::guard('admin')->user();
        $categories = Category::whereState(1)->whereType('news')->whereState(1)->whereHas('roles', function ($query)  use ($user) {
             $query->whereIn('id',$user->roles->pluck('role_id'));
        })->whereNull('parent_id')->get();

        $services = Service::where('model','news')->latest()->get();

        $sources = Source::whereState(1)->latest()->get();
        $types = Type::whereState(1)->latest()->get();
        $tags = Tag::all();
        $news = [];

        return view('news::Dashboard.Frest.news.create',compact('tags','sources','types','services','news','categories','trans'));

    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(NewsStoreRequest $request)
    {
        $this->authorize('news.create');



        $path = File::uploadByFileManager($request->image1);
        $file = File::uploadByFileManager($request->file);

        $publish_up = null; $publish_down=null;
        if($request->publish_up != null)
        {
            $publish_up = Str::convertToGregorian($request->publish_up . ':00');
        }

        if($request->publish_down != null)
        {
            $publish_down = Str::convertToGregorian($request->publish_down . ':00');
        }

        $instant = null;
          if($request->instant != null)
          {
              $instant = Str::convertToGregorian($request->instant . ':00');
          }

        $news = News::create([
            'title' => $request->title,
            'slug' => str_replace(' ', '-', $request->slug),
            'title_little' => $request->title_little,
            'lead' => $request->lead,
            'body' => $request->body,
            'state' => $request->state,
            'tran_id' => $request->tran_id,
            'type_id' => $request->type_id,
            'lang' => $request->lang,
            'file' =>  $file == null ? null : $file,
            'special' => $request->special,
            'link_source' => $request->link_source,
            'image1' =>  $path == null ? $path : $path,
            'cat_id' => $request->cat_id,
            "publish_up" => $publish_up,
            "publish_down" => $publish_down,
            "instant" => $instant,
            "admin_id" => Auth::guard('admin')->user()->id,
            "meta_desc" => $request->meta_desc,
            "meta_tag" => $request->meta_tag,
        ]);



        $tags = json_decode($request->tag);

        $tags_id = [];
        if($tags != null){
            foreach($tags as $tag){
                $tag = Tag::firstOrCreate(['name' => $tag->value]);
                array_push($tags_id,$tag->id);
            }
            $news->tags()->attach($tags_id);
        }

        $news->categories()->attach($request->categories);

        $news->services()->delete();

        $this->storeCustomField($news,$request->fields);



        if(isset($request->service_ids) && count($request->service_ids) > 0){
            foreach ($request->service_ids as $id){
                $news->services()->create([
                    'service_id' => $id,
                    'order' => ServiceModel::where('service_id',$id)->max('order') + 1
                ]);
            }
        }

        if(count($request->input('files')) > 0) {
            foreach ($request->input('files') as $key => $file){
                if($file != null){
                    $news->files()->create([
                        'file' => $file,
                        'desc' => $request->notes[$key],
                        'type' => 'galleries'
                    ]);
                }
            }
        }


        Cache::forget('index');
        if(isset($_POST['save']))
        {
            Session::flash('success','با موفقیت انجام شد');
            return redirect()->route('admin.news.index');
        }

        return redirect()->route('admin.news.edit',$news->id);





    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $this->authorize('news.edit');

        $news = News::whereId($id)->with('categories')->first();

        if($news->tran_id != null){
            $tran = News::find($news->tran_id);
            $trans = $tran->translates->pluck('lang')->toArray();
            $trans[] = $tran->lang;
        } else {
            $trans = $news->translates->pluck('lang')->toArray();
        }

        $user = Auth::guard('admin')->user();

        $services = Service::where('model','news')->latest()->get();
        $categories = Category::whereState(1)->whereType('news')->whereState(1)->whereHas('roles', function ($query)  use ($user) {
             $query->whereIn('id',$user->roles->pluck('role_id'));
        })->whereNull('parent_id')->get();


        $sources = Source::whereState(1)->latest()->get();
        $types = Type::whereState(1)->latest()->get();
        $tags = Tag::all();






        return view('news::Dashboard.Frest.news.edit',compact('news','services','sources','types','categories','tags','trans'));




    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(NewsUpdateRequest $request, $id)
    {
        $this->authorize('news.edit');


        $news = News::whereId($id)->first();


        $news->image1 = $request->image1;

        $news->file = File::uploadByFileManager($request->file,null);

        $publish_up = $news->publish_up; $publish_down = $news->publish_down;
        if($request->publish_up != null)
        {
            $publish_up = Str::convertToGregorian($request->publish_up . ':00');
        }

        if($request->publish_down != null)
        {
            $publish_down = Str::convertToGregorian($request->publish_down . ':00');
        }

        $instant = $news->instant;
        if($request->instant != null)
        {
            $instant = Str::convertToGregorian($request->instant . ':00');
        }

        $news->title = $request->title;
        $news->slug = $request->slug;
        $news->title_little = $request->title_little;
        $news->lead = $request->lead;
        $news->body = $request->body;
        $news->state = $request->state;
        $news->special = $request->special;
        $news->link_source = $request->link_source;
        $news->cat_id = $request->cat_id;
        $news->type_id = $request->type_id;
        $news->lang =  $request->lang;
        $news->instant = $instant;
        $news->publish_up = $publish_up;
        $news->publish_down = $publish_down;
        $news->meta_desc = $request->meta_desc;
        $news->meta_tag = $request->meta_tag;
        $news->update();



        $tags = json_decode($request->tag);

        $tags_id = [];
        if($tags != null){
            foreach($tags as $tag){
                $tag = Tag::firstOrCreate(['name' => $tag->value]);
                array_push($tags_id,$tag->id);
            }
            $news->tags()->sync($tags_id);
        }

        $news->categories()->sync($request->categories);

        $this->storeCustomField($news,$request->fields);


        $news->services()->delete();

        if(isset($request->service_ids) && count($request->service_ids) > 0){
            foreach ($request->service_ids as $id){
                $news->services()->create([
                    'service_id' => $id,
                    'order' => ServiceModel::where('service_id',$id)->max('order') + 1
                ]);
            }
        }


        $news->files()->where('type','galleries')->delete();
        if(count($request->input('files')) > 0) {

            foreach ($request->input('files') as $key => $file){
                if($file != null){
                    $news->files()->create([
                        'file' => $file,
                        'desc' => $request->notes[$key],
                        'type' => 'galleries'
                    ]);
                }
            }
        }


        Cache::forget('index');

        if(isset($_POST['save']))
        {
            Session::flash('success','با موفقیت انجام شد');
            return redirect()->route('admin.news.index');
        }

        return redirect()->route('admin.news.edit',$news->id);






    }




    public function destroy($id)
    {
        $this->authorize('news.delete');
        $news = News::find($id);
        $news->delete();


        Cache::forget('index');
        session::flash('success','با موفقیت انجام شد');
        return redirect()->back();

    }


    public function bulkAction()
    {

        $items = [];
        $items = explode(',',Request()->items);



        if(isset($_GET['delete']))
        {
            $this->authorize('news.delete');
            News::whereIn('id',$items)->delete();
        }
        if (isset($_GET['unPublish']))
        {
            $this->authorize('news.edit');
            News::whereIn('id',$items)->update([
                'state' => 0
            ]);
        }
        if(isset($_GET['publish']))
        {
            $this->authorize('news.edit');
            News::whereIn('id',$items)->update([
                'state' => 1
            ]);
        }

        if(isset($_GET['clone']))
        {
            $this->authorize('news.edit');
            $news = News::whereIn('id',$items)->get();

            foreach ($news as $index =>  $item){
               $newItem = $item->replicate();
               $newItem->title = $newItem->title . ' ' .Carbon::now();
               $newItem->created_at = Carbon::now();
               $newItem->save();
               $newItem->tags()->sync($item->categories->pluck('id')->toArray());
               $newItem->categories()->sync($item->categories->pluck('id')->toArray());
            }
        }


        Cache::forget('index');
        session::flash('success','با موفقیت انجام شد');
        return redirect()->back();

    }
}
