<?php

namespace Modules\News\app\Http\Requests\Dashboard\Frest\News;

use Illuminate\Foundation\Http\FormRequest;

class NewsStoreRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'title' => 'required',
        ];
    }


    protected function prepareForValidation()
    {
        $this->merge([
            'title' => $this->title == null ? 'عنوان پیش نویس' : $this->title,
            'body' => $this->body == null ? 'متن پیش نویس' : $this->body,
        ]);
    }
}
