<?php

namespace Modules\News\app\Models;


use Cviebrock\EloquentSluggable\Sluggable;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Modules\Admin\app\Models\Admin;
use Modules\Category\app\Models\Category;
use Modules\Comment\app\Models\Comment;
use Modules\Core\app\Http\Controllers\Helpers\Str;
use Modules\Field\app\Models\FieldModel;
use Modules\File\app\Models\File;
use Modules\Language\app\Models\Language;
use Modules\Role\app\Models\RoleModel;
use Modules\Service\app\Models\ServiceModel;
use Modules\Tag\app\Models\Tag;


class News extends Model
{
    use SoftDeletes;
    protected $fillable = ['id',
        'title',
        'slug',
        'title_little',
        'lead',
        'file',
        'instant',
        'body',
        'image1',
        'image2',
        'state',
        'special',
        'view_count',
        'comment_count',
        'meta_tag',
        'meta_desc',
        'cat_id',
        'source_id',
        'type_id',
        'publish_down',
        'publish_up',
        'created_at',
        'updated_at',
        'link_source',
        'admin_id',
        'tran_id',
        'lang'
    ];










    public function scopeActive($query)
    {
        $date = date('Y-m-d H:i:s');
        return $query

            ->where(function($q) use ($date) {
                $q->whereRaw('publish_up IS NULL OR publish_up < ?', [$date]);
            })
            ->where(function($q) use ($date) {
                $q ->whereRaw('publish_down IS NULL OR publish_down > ?', [$date]);
            })->where('state',1);
    }

    public function scopeHasService($query,$service)
    {
        if($service){
            return $query->whereHas('services',function($query) use ($service){
                return $query->where('service_id',$service->id);
            });
        } else {
            return $query->whereHas('services',function($query){
                return $query->whereIn('service_id',[]);
            });
        }

    }

    /**
     * Get all of the post's comments.
     */


    public function services()
    {
        return $this->morphMany(ServiceModel::class, 'services','model_type','model_id');
    }

    public function category()
    {
        return $this->belongsTo(Category::class, 'cat_id');
    }

    public function user()
    {
        return $this->belongsTo(Admin::class, 'admin_id');
    }

    public function type()
    {
        return $this->belongsTo(Type::class, 'type_id');
    }
    public function fields()
    {
        return $this->morphMany(FieldModel::class, 'fieldModel','model_type','model_id');
    }



    public function comments()
    {
        return $this->morphMany(Comment::class, 'comment','commentable_type','commentable_id');
    }

    public function commentsActive()
    {
        return $this->morphMany(Comment::class, 'comment','commentable_type','commentable_id')->where('state','=',1);
    }

    public function files()
    {
        return $this->morphMany(\Modules\File\app\Models\File::class, 'filable','file_type','file_id');
    }

    public function galleries()
    {
        return $this->morphMany(File::class, 'filable','file_type','file_id')->where('type','galleries');
    }

    public function categories()
    {
        return $this->morphToMany(Category::class, 'catgable');
    }


    public function source()
    {
        return $this->belongsTo(Source::class, 'source_id');
    }

    public function tags()
    {
        return $this->morphToMany(Tag::class, 'taggable');
    }

    public function children()
    {
        return $this->belongsToMany(News::class, 'news_news', 'news');
    }

    public function getImage1UrlAttribute($value){

       return $this->image1;

    }



    public function getFileUrlAttribute($value){

        return  $this->file;

    }





    public function translates(){
        return $this->hasMany(News::class,'tran_id','id');
    }
    public function language(){
        return $this->belongsTo(Language::class,'lang','name');
    }


    public function getRouteAttribute()
    {
        $lang = config('app.multi_lang') == true ? true : false;

        $prefix = 'news';
        if(config('app.prefix')) {
            return $lang != true ? "/show/{$prefix}/{$this->id}/{$this->slug}" : "/$this->lang/show/{$prefix}/{$this->id}/{$this->slug}";
        }
        return $lang != true ? "/show/{$prefix}/{$this->id}/{$this->slug}" : "/$this->lang/show/{$prefix}/{$this->id}/{$this->slug}";

    }

    public function cart(): MorphMany
    {
        return $this->morphMany(Cart::class , 'cartable');
    }

   }


