<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateNewsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('news', function (Blueprint $table) {
                  $table->id();

                $table->string('title');
                $table->string('slug');

                $table->string('title_little')->nullable();
                $table->text('lead')->nullable();
                $table->longText('body')->nullable();

                $table->string('image1')->nullable();
                $table->string('image2')->nullable();
                $table->string('link_source')->nullable();
                $table->string('slider')->nullable();
                $table->string('type_slider')->default('no-slider');

                $table->boolean('show_desc')->default(0);
                $table->boolean('state')->default(0);
                $table->boolean('special')->default(0);
                $table->boolean('state_comment')->default(0);
                $table->boolean('latest')->default(0);
                $table->boolean('instant')->default(0);
                $table->boolean('most')->default(0);

                $table->integer('view_count')->default(0);
                $table->integer('comment_count')->default(0);

                $table->string('author')->nullable();

                $table->text('meta_tag')->nullable();
                $table->text('meta_desc')->nullable();


                $table->text('sms_content')->nullable();

                $table->text('telegram_content')->nullable();


                $table->timestamp('publish_up')->nullable();
                $table->timestamp('publish_down')->nullable();


                $table->unsignedBigInteger('cat_id')->nullable();
            $table->foreign('cat_id')->references('id')->on('categories')->onDelete('set null');

                $table->unsignedBigInteger('admin_id')->nullable();
                $table->foreign('admin_id')->references('id')->on('admins')->onDelete('set null');

                $table->unsignedBigInteger('type_id')->nullable();
                $table->foreign('type_id')->references('id')->on('types')->onDelete('set null');

                $table->unsignedBigInteger('source_id')->nullable();
                $table->foreign('source_id')->references('id')->on('sources')->onDelete('set null');







                $table->softDeletes();
                $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('news');
    }
}
