<?php

namespace Modules\Note\app\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Modules\Note\Database\factories\NoteFactory;

class Note extends Model
{
    use HasFactory;
    protected $table = 'note';
    /**
     * The attributes that are mass assignable.
     */
    protected $fillable = [
        'note',
        'admin_id',
        'user_id',
        'object_id',
        'object_type',
        'state',
        'read'
    ];

    public function note()
    {
        return $this->morphTo(Note::class,'object_type','object_id');
    }
}
