<?php

namespace Modules\Page\app\Http\Controllers\Dashboard\Frest;



use App\Http\Controllers\Controller;

use Illuminate\Support\Facades\Session;
use Modules\Page\app\Models\Page;
use Modules\Page\app\Http\Requests\Dashboard\Frest\Page\PageStoreRequest;
use Modules\Page\app\Http\Requests\Dashboard\Frest\Page\PageUpdateRequest;
use Modules\Site\app\Models\Site;

class PageController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {

        $this->authorize('page.access');

            $pages = Page::when(Request()->tran_id != null,function ($query){
                $query->where('tran_id',Request()->tran_id);
            })
            ->when(Request()->tran_id == null,function ($query){
                $query->where('tran_id',null);
            })->latest()->paginate(15);

        return view('page::Dashboard.Frest.page.index' , compact('pages'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $this->authorize('page.create');
        $trans = Page::where('tran_id',Request()->tran_id)
            ->orWhere('id',Request()->tran_id)->pluck('lang')->toArray();



        return view('page::Dashboard.Frest.page.create',compact('trans'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(PageStoreRequest $request)
    {

        $this->authorize('page.create');

         $page = Page::create([
            'title' => $request->title,
            'body' => $request->body,
            'state' => $request->state,
            'meta_tag' => $request->meta_tag,
            'meta_desc' => $request->meta_desc,
            'lang' => $request->lang,
            'tran_id' => $request->tran_id,
        ]);


        if(count($request->input('files')) > 0) {
            foreach ($request->input('files') as $key => $file) {
                if ($file != null) {
                    $page->files()->create([
                        'file' => $file,
                        'desc' => $request->notes[$key],
                        'type' => 'galleries'
                    ]);
                }
            }
        }

        session::flash('success','با موفقیت انجام شد');
        return redirect()->route('admin.page.index');





    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
       //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit(Page $page)
    {
        $this->authorize('page.edit');
        if($page->tran_id != null){
            $tran = Page::find($page->tran_id);
            $trans = $tran->translates->pluck('lang')->toArray();
            $trans[] = $tran->lang;
        } else {
            $trans = $page->translates->pluck('lang')->toArray();
        }
        return view('page::Dashboard.Frest.page.edit',compact('page','trans'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(PageUpdateRequest $request,Page $page)
    {
        $this->authorize('page.edit');





        $page->title = $request->title;
        $page->body = $request->body;
        $page->lang = $request->lang;
        $page->meta_tag = $request->meta_tag;
        $page->meta_desc = $request->meta_desc;
        $page->state = $request->state;
        $page->save();


        $page->files()->where('type','galleries')->delete();
        if(count($request->input('files')) > 0) {

            foreach ($request->input('files') as $key => $file){
                if($file != null){
                    $page->files()->create([
                        'file' => $file,
                        'desc' => $request->notes[$key],
                        'type' => 'galleries'
                    ]);
                }
            }
        }

        session::flash('success','با موفقیت انجام شد');
        return redirect()->route('admin.page.index');

    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Page $page)
    {
        $this->authorize('page.delete');
        $page->delete();

        session::flash('success','با موفقیت انجام شد');
        return redirect()->route('admin.page.index');

    }


    public function bulkAction()
    {

        $items = [];
        $items = explode(',',Request()->items);


        if(isset($_GET['delete']))
        {
            $this->authorize('page.delete');
            Page::whereIn('id',$items)->delete();
        }
        if (isset($_GET['unPublish']))
        {
            $this->authorize('page.edit');
            Page::whereIn('id',$items)->update([
                'state' => 0
            ]);
        }
        if(isset($_GET['publish']))
        {
            $this->authorize('page.edit');
            Page::whereIn('id',$items)->update([
                'state' => 1
            ]);
        }



        session::flash('success','با موفقیت انجام شد');
        return redirect()->back();

    }


}
