<?php

namespace Modules\Page\app\Models;


use Cviebrock\EloquentSluggable\Sluggable;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Modules\Core\app\Http\Controllers\Helpers\Str;
use Modules\File\app\Models\File;
use Modules\Language\app\Models\Language;

class Page extends Model
{

     use Sluggable,SoftDeletes;


    public function sluggable():array
    {
        return [
            'slug' => [
                'source' => 'title'
            ]
        ];
    }


    protected $fillable = ['title','slug','body','view_count',
        'comment_count','state','state_comment','meta_tag',
        'meta_desc','image','tran_id',
        'lang'
    ];



    public function comments()
    {
        return $this->morphMany(Comment::class, 'commentable');
    }

    public function translates(){
        return $this->hasMany(Page::class,'tran_id','id');
    }
    public function language(){
        return $this->belongsTo(Language::class,'lang','name');
    }

    public function files()
    {
        return $this->morphMany(\Modules\File\app\Models\File::class, 'filable','file_type','file_id');
    }

    public function galleries()
    {
        return $this->morphMany(File::class, 'filable','file_type','file_id')->where('type','galleries');
    }

    public function getSlugAttribute(){
        return Str::slug($this->title);
    }

     public function getRouteAttribute()
     {
         $lang = config('app.multi_lang') == true ? true : false;
         $prefix = config('app.prefix') ? config('app.prefix') : 'page';
         if(config('app.prefix')) {
             return $lang != true ? "/{$prefix}/{$this->id}/{$this->slug}" : "/$this->lang/{$prefix}/{$this->id}/{$this->slug}";
         }
         return $lang != true ? "/{$prefix}/{$this->id}/{$this->slug}" : "/$this->lang/{$prefix}/{$this->id}/{$this->slug}";

     }
}
