<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreatePagesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('pages', function (Blueprint $table) {
              $table->id();
            $table->string('title');
            $table->string('slug');
            $table->text('body');

            $table->integer('view_count')->default(0);
            $table->integer('comment_count')->default(0);

            $table->boolean('state')->default(0);
            $table->boolean('state_comment')->default(0);

            $table->text('meta_tag')->nullable();
            $table->text('meta_desc')->nullable();

            $table->unsignedBigInteger('admin_id')->nullable();
            $table->foreign('admin_id')->references('id')->on('admins')->onDelete('set null');



            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('pages');
    }
}
