
@extends('core::Dashboard.Frest.Layouts.master')

@section('title')داشبورد@endsection

    @section('style')
        <link rel="stylesheet" href="{{asset('modules/core/vendor/libs/tagify/tagify.css')}}" />
        @endsection

    @section('script')
        <script src="{{asset('modules/core/editors/ckeditor/ckeditor.js')}}"></script>

        <script src="{{asset('modules/core/vendor/libs/tagify/tagify.js')}}"></script>

        <script>
            var options = {
                 filebrowserImageBrowseUrl: '/file-manager/ckeditor',
            };
            CKEDITOR.replace('body' ,options);
            $('#submit').on('keyup keypress', function(e) {
                var keyCode = e.keyCode || e.which;
                if (keyCode === 13) {
                    e.preventDefault();
                    return false;
                }
            });
        </script>

    @endsection

@section('content')

    @include('core::components.file_set_to_editor')
    <div class="row">
        <div class="col">
            <h6 class="mt-4 secondary-font">ویرایش</h6>
            <div class="card mb-3">
                <div class="card-header border-bottom primary-font">
                    <ul class="nav nav-tabs card-header-tabs" role="tablist">
                        <li class="nav-item">
                            <button class="nav-link active" data-bs-toggle="tab" data-bs-target="#tab1" role="tab" aria-selected="true">
                               اطلاعات
                            </button>
                        </li>
                        <li class="nav-item">
                            <button class="nav-link" data-bs-toggle="tab" data-bs-target="#publish" role="tab" aria-selected="true">
                                انتشار
                            </button>
                        </li>
                        <li class="nav-item">
                            <button class="nav-link" data-bs-toggle="tab" data-bs-target="#files" role="tab"
                                    aria-selected="true">
                                استایل ها و فایل ها
                            </button>
                        </li>
                    </ul>
                </div>

                <div class="tab-content">
                    <form id="save" action="{{route('admin.page.update',$page->id)}}" method="post">
                        {{ csrf_field() }}
                        @method('patch')
                        <div class="tab-pane fade active show" id="tab1" role="tabpanel">


                            <div class="row g-3">

                                <div class="col-md-12">

                                    <div class="row">






                                        <div class="col-md-8">
                                            <span>*</span>
                                            <label class="form-label" for="title">عنوان</label>
                                            <input type="text" id="title"  name="title" class="form-control" placeholder="عنوان" value="{{$page->title}}">
                                            @if($errors->has('title'))
                                                <div data-field="title" class="text-danger">{{ $errors->first('title') }}</div>
                                            @endif
                                        </div>


                                        <div class="col-md-2">
                                            <span>*</span>
                                            <label class="form-label" for="state">وضعیت</label>
                                            <div class="position-relative">
                                                <select required id="state" name="state" class="form-select" >
                                                    <option value="1" {{'1' == $page->state ? 'selected' : ''}}>فعال</option>
                                                    <option value="0" {{'0' == $page->state ? 'selected' : ''}}>غیر فعال</option>
                                                </select>
                                            </div>
                                        </div>



                                        <div class="col-md-12">
                                            <label class="form-label" for="desc">متن خبر</label>
                                            <textarea  type="text" id="body"  name="body" class="form-control" >{{$page->body}}</textarea>
                                            @if($errors->has('body'))
                                                <div data-field="desc" class="text-danger">{{ $errors->first('body') }}</div>
                                            @endif

                                            <br>
                                            <button type="button"  data-bs-toggle="modal" data-bs-target="#create-file-editor" class="btn btn-warning me-1">درج ویدیو و صوت در ادیتور</button>

                                        </div>

                                    </div>

                                </div>





                            </div>


                          </div>

                        <div class="tab-pane fade " id="publish" role="tabpanel">


                            <div class="row g-3">

                                <div class="col-md-6">

                                    <div class="row">

                                        <div class="col-md-12">
                                            <span>*</span>
                                            <label class="form-label" for="state">زبان</label>
                                            <div class="position-relative">
                                                <select required id="lang" name="lang" class="form-select" >
                                                    @foreach($languages as $language)
                                                        @if(!in_array($language->name,$trans) || $language->name == $page->lang)
                                                            <option value="{{$language->name}}" {{$language->name == $page->lang ? 'selected' : ''}}>
                                                                {{$language->title}}</option>
                                                        @endif
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>

                                        <div class="col-md-12">
                                            <label for="meta_tag" class="form-label">متا تگ</label>
                                            <input id="meta_tag" class="form-control" name="meta_tag" value="{{$page->meta_tag}}" />
                                        </div>

                                        <div  class="col-md-12">
                                            <label for="meta_desc" class="form-label">توضیحات متا</label>
                                            <textarea id="meta_desc" class="form-control" name="meta_desc">{{$page->meta_desc}}</textarea>
                                        </div>

                                    </div>

                                </div>





                            </div>


                        </div>

                        <div class="tab-pane fade " id="files" role="tabpanel">

                            <div class="row">

                                @for($i=0;$i<15;$i++)


                                    <div class="col-md-6">

                                        <div class="row">
                                            <div class="col-md-12">
                                                <label class="form-label" for="title">فایل</label>
                                                <div class="input-group">
                                                    <input type="text" id="input-gallery-{{$i + 1}}" class="form-control" name="files[]"
                                                           aria-label="Image" aria-describedby="button-gallery-{{$i + 1}}" value="{{isset($page->galleries[$i]) ? $page->galleries[$i]->file : ''}}">
                                                    <div class="input-group-append">
                                                        <button class="btn btn-outline-secondary" type="button" id="button-gallery-{{$i + 1}}">آپلود</button>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="col-md-12">
                                                <label class="form-label" for="title">توضیح</label>
                                                <div class="input-group">
                                                    <input type="text" id="notes" class="form-control" name="notes[]" aria-label="Image" value="{{isset($page->galleries[$i]) ? $page->galleries[$i]->desc : ''}}" >
                                                </div>
                                            </div>
                                        </div>

                                    </div>

                                @endfor
                            </div>

                        </div>
                        <div class="pt-4">
                            <button type="submit" name="save" class="btn btn-primary me-sm-3 me-1">ثبت</button>
                            <a href="{{route('admin.page.index')}}" type="reset" class="btn btn-label-secondary">انصراف</a>
                        </div>

                    </form>
                </div>
            </div>
        </div>
    </div>




@endsection
