@extends('core::Dashboard.Frest.Layouts.master')

@section('title')داشبورد@endsection

    @section('style')

        @endsection

    @section('script')

    @endsection

@section('content')


    <div class="card" style="margin-bottom:15px; ">
        <p class="demo-inline-spacing">
            <button type="button" class="btn btn-icon me-2 btn-primary" data-bs-toggle="collapse" data-bs-target=".multi-collapse" aria-expanded="false" aria-controls="multiCollapseExample1 multiCollapseExample2">
                <i class="bx bx-search bx-sm"></i>
            </button>


        </p>

        <section>
            <div class="row">

                <div class="row">
                    <div class="col-12 col-md-12">
                        <div class="collapse multi-collapse" id="multiCollapseExample2">
                            <div class="col-md-12" style="padding: 0.8%;">
                                <form id="filter" action="{{route('admin.page.index')}}" method="get">
                                    <div class="row">
                                        <div class="col-md-2">
                                            <input type="text" id="q"  name="q" class="form-control" placeholder="جستجو" value="{{old('q')}}">
                                        </div>
                                        <div class="col-md-2">
                                            <button onclick="submitForm('filter')" name="filter" type="button" class="btn btn-primary me-1">جستجو</button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>



            </div>
        </section>
    </div>


    <div class="card">
        <form action="{{route('admin.bulk.pages')}}" method="get">
            <p class="demo-inline-spacing">
                @if(Request()->tran_id == null)
                    <a class="btn btn-primary me-1" href="{{route('admin.page.create')}}" role="button" aria-expanded="false" >جدید</a>
                @endif
                <button name="publish" type="submit" class="btn btn-success me-1"   >انتشار</button>
                <button name="unPublish" type="submit" class="btn btn-gray me-1"  >غیر انتشار</button>
                <button name="delete" type="submit" class="btn btn-danger me-1"  >حذف</button>
            </p>
            <input type="text" id="items" name="items" value="" style="display: none;">
        </form>
        <h5 class="card-header">{{\Modules\Core\app\Http\Controllers\Helpers\Str::getTitleBoard("صفحات")}}</h5>
        <div class="table-responsive text-nowrap">
            <table class="table table-sm">
                <thead>
                <tr>
                    <th>
                        <div class="bulk-ids checkbox-primary m-r-15">
                            <input id="bulk-ids" onClick="toggle(this)" type="checkbox">
                            <label for="bulk-ids">#</label>
                        </div>
                    </th>
                    <th>عنوان</th>
                    <th>وضعیت</th>
                    <th>ایجاد</th>
                    <th>نویسنده</th>
                    <th>عملیات</th>
                </tr>
                </thead>
                <tbody>

                @foreach($pages as $item)
                    <tr >
                        <th>
                            <div class="bulk-ids checkbox-primary m-r-15">
                                <input id="bulk-ids" onClick="syncItems(this)" name="ids[]"value="{{$item->id}}" type="checkbox">
                                <label for="bulk-ids"></label>
                            </div>
                        </th>
                        <td>
                            <a href="{{route('admin.page.index',['tran_id' => $item->id])}}">
                                <b>{{$item->title}}</b>
                            </a></br>
                        </td>

                        @if($item->state == 1)
                            <td><span class="badge bg-label-success me-1">فعال</span></td>
                        @endif
                        @if($item->state == 0)
                            <td><span class="badge bg-label-danger me-1">غیرفعال</span></td>
                        @endif



                        <td>
                            @if($item->created_at != null)
                                {{ Verta($item->created_at)->format('Y-m-d H:i:s') }}
                            @endif
                        </td>
                        <td>
                            @isset($item->user)
                                <b>{{$item->user->name}}  {{$item->user->family}}</b> </br>
                            @endisset
                        </td>



                        <td>
                            <div class="dropdown">
                                <button type="button" class="btn p-0 dropdown-toggle hide-arrow" data-bs-toggle="dropdown"><i class="bx bx-dots-vertical-rounded"></i></button>
                                <div class="dropdown-menu">
                                    <a class="dropdown-item" href="{{ route('admin.page.edit' ,$item->id) }}"><i class="bx bx-edit-alt me-1"></i>ویرایش</a>
                                    @if($item->tran_id == null && count($languages) > count($item->translates) + 1)
                                        <a class="dropdown-item" href="{{ route('admin.page.create' ,['tran_id' => $item->id]) }}"><i class="bx bx-edit-alt me-1"></i>ترجمه</a>
                                    @endif
                                    <button class="dropdown-item" onclick="event.preventDefault();confirmDelete('delete-{{$item->id}}')"><i class="bx bx-trash me-1"></i>حذف</button>
                                    <form id="delete-{{$item->id}}" action="{{ route('admin.page.destroy', $item->id) }}" method="POST" style="display: none;">
                                        {{ csrf_field() }}
                                        {{ method_field('DELETE') }}
                                    </form>
                                </div>
                            </div>
                        </td>
                    </tr>

                @endforeach

                </tbody>
            </table>

            <div style="margin-top: 10%;">
                {{ $pages->render() }}
            </div>
        </div>





    </div>



@endsection
