<?php

namespace Modules\Poll\app\Http\Controllers\Dashboard\Frest;

use Carbon\Carbon;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Session;
use Modules\Core\app\Http\Controllers\Helpers\Str;
use Modules\News\app\Models\News;
use Modules\Poll\app\Models\Poll;
use Modules\Poll\app\Models\Pollitem;


class PollController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $polls = Poll::latest()->paginate(15);

        return view('poll::Dashboard.Frest.poll.index',compact('polls'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('poll::Dashboard.Frest.poll.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {


        $publish_up = null; $publish_down=null;
        if($request->publish_up != null)
        {
            $publish_up = Str::convertToGregorian($request->publish_up . ':00');
        }

        if($request->publish_down != null)
        {
            $publish_down = Str::convertToGregorian($request->publish_down . ':00');
        }

        $poll = Poll::create([
            'title' => $request->title,
            'ename' => $request->ename,
            'body' => $request->body,
            'publish_up' => $publish_up,
            'publish_down' => $publish_down,
            'state' => $request->state,
            ]);


        if($poll){
            foreach ($request->items as $item)
            {
                Pollitem::create([
                    'title' => $item,
                    'poll_id' => $poll->id
                ]);
            }
        }


        return redirect()->route('admin.poll.index')->with('success','با موفقیت انجام شد');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(Poll $poll)
    {


        return view('poll::Dashboard.Frest.poll.detail',compact('poll'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $poll = Poll::find($id);

        return view('poll::Dashboard.Frest.poll.edit',compact('poll'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $poll = Poll::find($id);

        $publish_up = $poll->publish_up; $publish_down = $poll->publish_down;
        if($request->publish_up != null)
        {
            $publish_up = Str::convertToGregorian($request->publish_up . ':00');
        }

        if($request->publish_down != null)
        {
            $publish_down = Str::convertToGregorian($request->publish_down . ':00');
        }

        $poll->title = $request->title;
        $poll->ename = $request->ename;
        $poll->state = $request->state;
        $poll->body = $request->body;
        $poll->publish_up = $publish_up;
        $poll->publish_down = $publish_down;
        $poll->save();



        if(isset($request->items_old)){

            foreach ($request->items_old as $key => $item)
            {

                $pollItem = Pollitem::find($item);

                if($request->title_old[$key] != null)
                {
                    $pollItem->title = $request->title_old[$key];
                    $pollItem->save();
                }

            }

        }

        if($poll){
            foreach ($request->items as $item)
            {
                if($item != null)
                {
                    Pollitem::create([
                        'title' => $item,
                        'poll_id' => $poll->id
                    ]);
                }

            }
        }


        return redirect()->route('admin.poll.index')->with('success','با موفقیت انجام شد');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $poll = Poll::find($id);

        $poll->delete();

        return redirect()->back()->with('success','با موفقیت انجام شد');

    }



    public function bulkAction()
    {

        $items = [];
        $items = explode(',',Request()->items);



        if(isset($_GET['delete']))
        {
            $this->authorize('news.delete');
           Poll::whereIn('id',$items)->delete();
        }
        if (isset($_GET['unPublish']))
        {
            $this->authorize('news.edit');
           Poll::whereIn('id',$items)->update([
                'state' => 0
            ]);
        }
        if(isset($_GET['publish']))
        {
            $this->authorize('news.edit');
           Poll::whereIn('id',$items)->update([
                'state' => 1
            ]);
        }




        session::flash('success','با موفقیت انجام شد');
        return redirect()->back();

    }
}
