<?php

namespace Modules\Poll\app\Models;


use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Poll extends Model
{
    use SoftDeletes;
    protected $fillable = ['title','publish_up','ename', 'publish_down','state','body'];



    public function scopeActive($query)
    {
        $date = date('Y-m-d H:i:s');
        return $query
            ->where('state',1) ;
    }


    public function items(){
        return $this->hasMany(Pollitem::class,'poll_id');
    }
    public function answers(){
        return $this->hasMany(Pollanswer::class,'poll_id');
    }

    public function gethasParticipateSurveyAttribute() {
        $count = $this->whereHas('answers',function ($query){
            $query->where('ip',Request()->ip());
        })->count();

        if($count > 0) {
            return true;
        } else {
            return false;
        }
    }


}


