<?php

namespace Modules\Poll\app\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Pollitem extends Model
{
    use SoftDeletes;
    protected $fillable = ['title','color','image','poll_id'];



    public function answers (){
        return $this->hasMany(Pollanswer::class,'item_id');
    }

    public function getVoteAttribute()
    {
        $participants = Pollanswer::wherePoll_id($this->poll_id)->count();
        $count = Pollanswer::whereItem_id($this->id)->count();
        $vote = 0;


        if($participants > 0 && $count > 0)
        {
            $vote = ($count / $participants) * 100 ;
        }

        return round($vote);

    }
}
