@extends('core::Dashboard.Frest.Layouts.master')

@section('title')ایجاد نظرسنجی@endsection

@section('script')
    <script>
        $(document).on('click', '.create-practical .btn-add', function(e)
        {
            e.preventDefault();

            var controlForm = $('.create-practical .form:first'),
                currentEntry = $(this).parents('.entry:first'),
                newEntry = $(currentEntry.clone()).appendTo(controlForm);

            newEntry.find('input').val('');
            controlForm.find('.entry:not(:last) .btn-add')
                .removeClass('btn-add').addClass('btn-remove')
                .removeClass('btn-success').addClass('btn-danger')
                .html('حذف');
        }).on('click', '.btn-remove', function(e)
        {
            $(this).parents('.entry:first').remove();

            e.preventDefault();
            return false;
        });
    </script>
@endsection

@section('content')


    <div class="row">
        <div class="col">
            <h6 class="mt-4 secondary-font">ایجاد</h6>
            <div class="card mb-3">
                <div class="card-header border-bottom primary-font">
                    <ul class="nav nav-tabs card-header-tabs" role="tablist">

                        <li class="nav-item">
                            <button class="nav-link active" data-bs-toggle="tab" data-bs-target="#tab1" role="tab" aria-selected="true">
                               اطلاعات
                            </button>
                        </li>

                        <li class="nav-item">
                            <button class="nav-link" data-bs-toggle="tab" data-bs-target="#items" role="tab" aria-selected="true">
                                آیتم ها
                            </button>
                        </li>


                    </ul>
                </div>

                <div class="tab-content">
                    <form id="formAutoSave" action="{{route('admin.poll.store')}}" method="post">
                        {{ csrf_field() }}

                        <div class="tab-pane fade active show" id="tab1" role="tabpanel">


                            <div class="row g-3">

                                <div class="col-md-12">

                                    <div class="row">

                                        <div class="col-md-5">
                                            <span>*</span>
                                            <label class="form-label" for="title">عنوان</label>
                                            <input type="text" id="title"  name="title" class="form-control" placeholder="عنوان" value="{{old('title')}}">
                                            @if($errors->has('title'))
                                                <div data-field="title" class="text-danger">{{ $errors->first('title') }}</div>
                                            @endif
                                        </div>

                                        <div class="col-md-4">
                                            <span>*</span>
                                            <label class="form-label" for="title">کلید</label>
                                            <input type="text" id="ename"  name="ename" class="form-control" placeholder="کلید" value="{{old('ename')}}">
                                            @if($errors->has('ename'))
                                                <div data-field="ename" class="text-danger">{{ $errors->first('ename') }}</div>
                                            @endif
                                        </div>

                                        <div class="col-md-2">
                                            <span>*</span>
                                            <label class="form-label" for="state">وضعیت</label>
                                            <div class="position-relative">
                                                <select required id="state" name="state" class="form-select" >
                                                    <option value="1" {{'1' == old('state') ? 'selected' : ''}}>فعال</option>
                                                    <option value="0" {{'0' == old('state') ? 'selected' : ''}}>غیر فعال</option>
                                                </select>
                                            </div>
                                        </div>

                                        <div class="col-md-12">
                                            <label class="form-label" for="desc">متن خبر</label>
                                            <textarea  type="text" id="body"  name="body" class="form-control" ></textarea>
                                            @if($errors->has('body'))
                                                <div data-field="desc" class="text-danger">{{ $errors->first('body') }}</div>
                                            @endif
                                        </div>

                                    </div>

                                </div>





                            </div>


                          </div>

                        <div class="tab-pane fade " id="items" role="tabpanel">
                            <div class="row g-3">

                                <div class="col-md-6">
                                    <div class="card-box">

                                        <h5 class="text-muted text-uppercase m-t-0 m-b-20"><b>گزینه ها</b></h5>

                                        <div class="row">

                                            <div class="form-group create-practical col-md-12" >

                                                <div class="create-practical">
                                                    <div class="form" autocomplete="off">
                                                        <div class="entry">
                                                            <div class="row">

                                                                <div class="form-group col-lg-10" >
                                                                    <label for="uploade">گزینه</label>
                                                                    <input class="form-control" id="items" name="items[]"  type="text" value="{{old('items')}}">
                                                                </div>

                                                                <div class="form-group col-md-2" style="padding: 25px 0 0 0;">

                                                                    <button type="button" class="btn btn-success waves-effect btn-add">
                                                                         بعدی
                                                                    </button>
                                                                </div>
                                                            </div>

                                                        </div>
                                                    </div>

                                                </div>
                                            </div>

                                        </div>

                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="col-md-12">
                                        <label for="flatpickr-datetime" class="form-label">تاریخ و ساعت  شروع انتشار</label>
                                        <input type="text" class="form-control" placeholder="YYYY-MM-DD HH:MM" name="publish_up" id="publish_up"  value="{{old('publish_up')}}" />
                                    </div>

                                    <div class="col-md-12">
                                        <label for="flatpickr-datetime" class="form-label">تاریخ و ساعت پایان انتشار</label>
                                        <input type="text" class="form-control" placeholder="YYYY-MM-DD HH:MM" name="publish_down" id="publish_down" value="{{old('publish_down')}}" />
                                    </div>
                                </div>

                            </div>
                        </div>



                        <div class="pt-4">
                            <button type="submit" name="save" class="btn btn-primary me-sm-3 me-1">ثبت</button>
                            <a href="{{route('admin.poll.index')}}" type="reset" class="btn btn-label-secondary">انصراف</a>
                        </div>

                    </form>
                </div>
            </div>
        </div>
    </div>




@endsection
