@extends('core::Dashboard.Frest.Layouts.master')

@section('title')داشبورد@endsection

    @section('style')

        @endsection

    @section('script')

    @endsection

@section('content')


    <div class="card" style="margin-bottom:15px; ">
        <p class="demo-inline-spacing">
            <button type="button" class="btn btn-icon me-2 btn-primary" data-bs-toggle="collapse" data-bs-target=".multi-collapse" aria-expanded="false" aria-controls="multiCollapseExample1 multiCollapseExample2">
                <i class="bx bx-search bx-sm"></i>
            </button>


        </p>

        <section>
            <div class="row">

                <div class="row">
                    <div class="col-12 col-md-12">
                        <div class="collapse multi-collapse" id="multiCollapseExample2">
                            <div class="col-md-12" style="padding: 0.8%;">
                                <form id="filter" action="{{route('admin.poll.index')}}" method="get" target="_blank">
                                    <div class="row">

                                        <div class="col-md-2">
                                            <label for="selectpickerSelectDeselect" class="form-label">جستجو</label>
                                            <input type="text" id="q"  name="q" class="form-control" placeholder="جستجو" value="{{old('q')}}">
                                        </div>

                                        <div class="col-3">
                                            <label for="selectpickerSelectDeselect" class="form-label">وضعیت خبر</label>
                                            <select id="selectpickerSelectDeselect" name="state[]" class="selectpicker w-100" data-style="btn-default" multiple data-actions-box="true" data-live-search="true">
                                                    <option value="1">فعال</option>
                                                    <option value="0">غیر فعال</option>
                                            </select>
                                        </div>

                                        <div class="col-3">
                                            <label for="selectpickerSelectDeselect" class="form-label">ویژه</label>
                                            <select id="selectpickerSelectDeselect" name="special[]" class="selectpicker w-100" data-style="btn-default" multiple data-actions-box="true" data-live-search="true">
                                                <option value="1">ویژه</option>
                                                <option value="0">غیر ویژه</option>
                                            </select>
                                        </div>


                                        <div class="col-2">
                                            <label for="flatpickr-datetime" class="form-label">از تاریخ</label>
                                            <input type="text" class="form-control" placeholder="YYYY-MM-DD HH:MM" name="start_date" id="publish_up" />
                                        </div>

                                        <div class="col-2">
                                            <label for="flatpickr-datetime" class="form-label">تا تاریخ</label>
                                            <input type="text" class="form-control" placeholder="YYYY-MM-DD HH:MM" name="end_date" id="publish_down" />
                                        </div>



                                      <div class="row" style="margin-top: 20px;">
                                          <div class="col-md-12">
                                              <div class="row" style="justify-content: center;">
                                                  <div class="col-md-1">
                                                      <button name="filter" type="submit" class="btn btn-primary me-1">جستجو</button>
                                                  </div>
                                                  <div class="col-md-1">
                                                      <button name="print" type="submit" class="btn btn-warning me-1">پرینت</button>
                                                  </div>

                                                  <div class="col-md-1">
                                                      <button name="excel" type="submit" class="btn btn-success me-1">اکسل</button>
                                                  </div>

                                                  <div class="col-md-2">
                                                      <button name="pdf" type="submit" class="btn btn-danger me-1">پی دی اف</button>
                                                  </div>
                                              </div>
                                          </div>
                                      </div>

                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>



            </div>
        </section>
    </div>


    <div class="card">
        <form action="{{route('admin.bulk.polls')}}" method="get" >
            <p class="demo-inline-spacing" >
                <a class="btn btn-primary me-1" href="{{route('admin.poll.create')}}" role="button" aria-expanded="false" >جدید</a>
                <button name="publish" type="submit" class="btn btn-success me-1"   >انتشار</button>
                <button name="unPublish" type="submit" class="btn btn-gray me-1"  >غیر انتشار</button>
                <button name="delete" type="submit" class="btn btn-danger me-1"  >حذف</button>
            </p>
            <input type="text" id="items" name="items" value=""  style="display: none;">
        </form>
        <h5 class="card-header">منابع خبری</h5>
        <div class="table-responsive text-nowrap">
            <table class="table table-sm">
                <thead>
                <tr>
                    <th>
                        <div class="bulk-ids checkbox-primary m-r-15">
                            <input id="bulk-ids" onClick="toggle(this)" type="checkbox">
                            <label for="bulk-ids">#</label>
                        </div>
                    </th>
                    <th>عنوان</th>
                    <th>انتشار</th>
                    <th>ایجاد</th>
                    <th>عملیات</th>
                </tr>
                </thead>
                <tbody>

                @foreach($polls as $item)
                    <tr>

                        <th>
                            <div class="bulk-ids checkbox-primary m-r-15">
                                <input id="bulk-ids" onClick="syncItems(this)" name="ids[]"value="{{$item->id}}" type="checkbox">
                                <label for="bulk-ids"></label>
                            </div>
                        </th>
                        <td>
                            <b class="{{$item->state == 1 ? 'active' : 'inactive'}}">{{$item->id}} - {{$item->title}}</b>
                        </td>
                        <td>
                            @if($item->publish_up != null)
                                {{ Verta($item->publish_up)->format('Y-m-d H:i:s') }}
                            @endif
                            <br>
                            @if($item->publish_down != null)
                                {{ Verta($item->publish_down)->format('Y-m-d H:i:s') }}
                            @endif
                        </td>

                        <td>
                            @if($item->created_at != null)
                                {{ Verta($item->created_at)->format('Y-m-d H:i:s') }}
                            @endif
                        </td>



                        <td>
                            <div class="dropdown">
                                <button type="button" class="btn p-0 dropdown-toggle hide-arrow" data-bs-toggle="dropdown"><i class="bx bx-dots-vertical-rounded"></i></button>
                                <div class="dropdown-menu">
                                    <a class="dropdown-item" href="{{ route('admin.poll.edit' ,$item->id) }}"><i class="bx bx-edit-alt me-1"></i>ویرایش</a>

                                    <button class="dropdown-item" onclick="event.preventDefault();confirmDelete('delete-{{$item->id}}')"><i class="bx bx-trash me-1"></i>حذف</button>
                                    <form id="delete-{{$item->id}}" action="{{ route('admin.poll.destroy', $item->id) }}" method="POST" style="display: none;">
                                        {{ csrf_field() }}
                                        {{ method_field('DELETE') }}
                                    </form>
                                </div>
                            </div>
                        </td>


                    </tr>

                @endforeach

                </tbody>
            </table>

            <div style="margin-top: 10%;">
                {{ $polls->render() }}
            </div>
        </div>





    </div>



@endsection
