<?php

namespace Modules\Portfolio\app\Http\Controllers\Dashboard\Frest;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Session;
use Modules\Portfolio\app\Http\Requests\Dashboard\Frest\portfolio_category\PortfolioCategoryStorRequest;
use Modules\Portfolio\app\Http\Requests\Dashboard\Frest\portfolio_category\PortfolioCategoryUpdateRequest;
use Modules\Portfolio\app\Models\PortfolioCategory;

class PortfolioCategoryController extends Controller
{
    public function index()
    {
        $portfolio_categories = PortfolioCategory::all();
        return view('portfolio::Dashboard.Frest.category.index', compact('portfolio_categories'));
    }

    public function store(PortfolioCategoryStorRequest $request)
    {
        $category = PortfolioCategory::create([
            'title' => $request->title,
            'name' => $request->name,
            'state' => $request->state,
        ]);

        session::flash('success','با موفقیت انجام شد');
        return redirect()->route('admin.portfolio_category.index');
    }

    public function show($id)
    {
        return view('portfolio::show');
    }

    public function update(PortfolioCategoryUpdateRequest $request, $id)
    {
        $portfolio_category = PortfolioCategory::find($id);
        $portfolio_category->title = $request->title;
        $portfolio_category->name = $request->name;
        $portfolio_category->state = $request->state;
        $portfolio_category->update();

        Session::flash('success','با موفقیت انجام شد');
        return redirect()->route('admin.portfolio_category.index');
    }

    public function destroy($id)
    {
        $portfolio_category = PortfolioCategory::find($id);

        $portfolio_category->delete();

        Session::flash('success','با موفقیت انجام شد');
        return redirect()->back();
    }

    public function bulkAction()
    {

        $items = [];
        $items = explode(',',Request()->items);

        if(isset($_GET['delete']))
        {
//            $this->authorize('education.delete');
            PortfolioCategory::whereIn('id',$items)->delete();
        }
        if (isset($_GET['unPublish']))
        {
//            $this->authorize('product.edit');
            PortfolioCategory::whereIn('id',$items)->update([
                'state' => 0
            ]);
        }
        if(isset($_GET['publish']))
        {
//            $this->authorize('product.edit');
            PortfolioCategory::whereIn('id',$items)->update([
                'state' => 1
            ]);
        }

        session::flash('success','با موفقیت انجام شد');
        return redirect()->back();

    }

}
