<?php

namespace Modules\Portfolio\app\Http\Controllers\Dashboard\Frest;

use App\Http\Controllers\Controller;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\Session;
use Modules\Portfolio\app\Http\Requests\Dashboard\Frest\portfolio\PortfolioStorRequest;
use Modules\Portfolio\app\Http\Requests\Dashboard\Frest\portfolio\PortfolioUpdateRequest;
use Modules\Portfolio\app\Models\Portfolio;
use Modules\Portfolio\app\Models\PortfolioCategory;
use Modules\Service\app\Models\Service;
use Modules\Service\app\Models\ServiceModel;

class PortfolioController extends Controller
{
    public function index()
    {
        $portfolios = Portfolio::all();
        return view('portfolio::Dashboard.Frest.portfolio.index', compact('portfolios'));
    }

    public function create()
    {
        $services = Service::where('model','portfolio')->latest()->get();
        $portfolio_categories = PortfolioCategory::where('state', 1)->get();
        return view('portfolio::Dashboard.Frest.portfolio.create', compact('services', 'portfolio_categories'));
    }

    public function store(PortfolioStorRequest $request)
    {
        $portfolio = Portfolio::create([
            'title' => $request->title,
            'lead' => $request->lead,
            'image' => $request->image,
            'video' => $request->video,
            'cat_id' => $request->cat_id,
            'body' => $request->bodyy,
            'state' => 1,
        ]);

        if(isset($request->service_ids) && count($request->service_ids) > 0){
            foreach ($request->service_ids as $id){
                $portfolio->services()->create([
                    'service_id' => $id,
                    'order' => ServiceModel::where('service_id',$id)->max('order') + 1
                ]);
            }
        }
        session::flash('success','با موفقیت انجام شد');
        return redirect()->route('admin.portfolio.index');
    }

    public function show($id)
    {
        return view('portfolio::show');
    }

    public function edit($id)
    {
        $portfolio = Portfolio::with('services')->where('id', $id)->first();
        $portfolio_categories = PortfolioCategory::where('state', 1)->get();
        $services = Service::where('model','portfolio')->latest()->get();
        return view('portfolio::Dashboard.Frest.portfolio.edit', compact('services', 'portfolio_categories', 'portfolio'));
    }

    public function update(PortfolioUpdateRequest $request, $id)
    {
        $portfolio = Portfolio::find($id);
        $portfolio->title = $request->title;
        $portfolio->lead = $request->lead;
        $portfolio->body = $request->bodyy;
        $portfolio->cat_id = $request->cat_id;
        $portfolio->image = $request->image;
        $portfolio->video = $request->video;
        $portfolio->update();

        if(isset($request->service_ids) && count($request->service_ids) > 0){
            foreach ($request->service_ids as $id){
                $portfolio->services()->create([
                    'service_id' => $id,
                    'order' => ServiceModel::where('service_id',$id)->max('order') + 1
                ]);
            }
        }
        Session::flash('success','با موفقیت انجام شد');
        return redirect()->route('admin.portfolio.index');
    }

    public function destroy($id)
    {
        $portfolio = Portfolio::find($id);
        $portfolio->delete();

        Session::flash('success','با موفقیت انجام شد');
        return redirect()->back();
    }
    public function bulkAction()
    {

        $items = [];
        $items = explode(',',Request()->items);

        if(isset($_GET['delete']))
        {
//            $this->authorize('education.delete');
            Portfolio::whereIn('id',$items)->delete();
        }
        if (isset($_GET['unPublish']))
        {
//            $this->authorize('product.edit');
            Portfolio::whereIn('id',$items)->update([
                'state' => 0
            ]);
        }
        if(isset($_GET['publish']))
        {
//            $this->authorize('product.edit');
            Portfolio::whereIn('id',$items)->update([
                'state' => 1
            ]);
        }

        session::flash('success','با موفقیت انجام شد');
        return redirect()->back();

    }
}
