<?php

namespace Modules\Portfolio\app\Http\Requests\Dashboard\Frest\portfolio;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class PortfolioStorRequest extends FormRequest
{
    /**
     * Get the validation rules that apply to the request.
     */
    public function rules(): array
    {
        return [
            'title' => [
                'required',
                Rule::unique('portfolio', 'title'),
            ],
            'image' => [
                'required',
            ],
            'service_ids' => [
                'required',
            ],
            'cat_id' => [
                'required',
            ],
        ];
    }

    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }
}
