<?php

namespace Modules\Portfolio\app\Http\Requests\Dashboard\Frest\portfolio;

use http\Env\Request;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class PortfolioUpdateRequest extends FormRequest
{
    /**
     * Get the validation rules that apply to the request.
     */
    public function rules(): array
    {
        $portfolio = $this->route('portfolio');
        return [
            'title' => [
                'required',
                Rule::unique('portfolio', 'title')->ignore($portfolio),
            ],
            'image' => [
                'required',
            ],
            'service_ids' => [
                'required',
            ],
            'cat_id' => [
                'required',
            ],
        ];
    }

    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }
}
