<?php

namespace Modules\Portfolio\app\Http\Requests\Dashboard\Frest\portfolio_category;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class PortfolioCategoryStorRequest extends FormRequest
{
    /**
     * Get the validation rules that apply to the request.
     */
    public function rules(): array
    {
        return [
            'title' => [
                'required',
                Rule::unique('portfolio_category', 'title'),
            ],
            'name' => [
                'required',
                Rule::unique('portfolio_category', 'name'),
            ],
        ];
    }

    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }
}
