<?php

namespace Modules\Portfolio\app\Http\Requests\Dashboard\Frest\portfolio_category;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class PortfolioCategoryUpdateRequest extends FormRequest
{
    /**
     * Get the validation rules that apply to the request.
     */
    public function rules(): array
    {
        $portfolio_categoryId = $this->route('portfolio_category');
        return [
            'title' => [
                'required',
                Rule::unique('portfolio_category', 'title')->ignore($portfolio_categoryId),
            ],
            'name' => [
                'required',
                Rule::unique('portfolio_category', 'name')->ignore($portfolio_categoryId),
            ],
        ];
    }

    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }
}
