<?php

namespace Modules\Portfolio\app\Models;

use Cviebrock\EloquentSluggable\Sluggable;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Modules\Portfolio\Database\factories\PortfolioFactory;
use Modules\Service\app\Models\ServiceModel;

class Portfolio extends Model
{
    use Sluggable,HasFactory;


    protected $table = 'portfolio';

    protected $fillable = [
        'title',
        'slug',
        'lead',
        'body',
        'image',
        'video',
        'cat_id',
        'state'
    ];

    public function sluggable():array
    {
        return [
            'slug' => [
                'source' => 'title'
            ]
        ];
    }

    /**
     * Get the category associated with the portfolio.
     */
    public function category()
    {
        return $this->belongsTo(PortfolioCategory::class, 'cat_id');
    }

    public function services()
    {
        return $this->morphMany(ServiceModel::class, 'serviceModel','model_type','model_id');
    }

    public function getRouteAttribute()
    {
        return "/portfolio/{$this->slug}";
    }

}
