<?php

namespace Modules\Portfolio\app\Models;

use Cviebrock\EloquentSluggable\Sluggable;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Modules\Portfolio\Database\factories\PortfolioCategoryFactory;

class PortfolioCategory extends Model
{
    use HasFactory,Sluggable;

    protected $table = 'portfolio_category';

    protected $fillable = [
        'title',
        'slug',
        'name',
        'state',
    ];

    public function sluggable():array
    {
        return [
            'slug' => [
                'source' => 'name'
            ]
        ];
    }

    public function portfolios()
    {
        return $this->hasMany(Portfolio::class, 'cat_id');
    }

    public function getRouteAttribute()
    {
        return "/portfolios/{$this->slug}";
    }
}
