@extends('core::Dashboard.Frest.Layouts.master')

@section('title')
    داشبورد
@endsection

@section('style')
@endsection

@section('script')
    <script src="{{ asset('modules/core/js/dashboards-analytics.js') }}"></script>
@endsection

@section('content')
    <div class="card" style="margin-bottom:15px; ">
        <p class="demo-inline-spacing">
            <button type="button" class="btn btn-icon me-2 btn-primary" type="button" data-bs-toggle="collapse"
                    data-bs-target=".multi-collapse" aria-expanded="false"
                    aria-controls="multiCollapseExample1 multiCollapseExample2">
                <i class="bx bx-search bx-sm"></i>
            </button>


        </p>

        <section>
            <div class="row">

            </div>
        </section>
    </div>


    <div class="card">
        <x-modal id="add_portfolio_category" size="sm" header="ثبت دسته بندی نمونه کار">
            <form id="formData" action="{{ route('admin.portfolio_category.store') }}" method="post">
                {{ csrf_field() }}

                <div class="tab-pane fade active show" id="tab1" role="tabpanel">
                    <div class="row g-3">
                        <div class="col-md-12">
                            <div class="row">
                                <div class="col-md-6">
                                    <span>*</span>
                                    <label class="form-label" for="title">عنوان</label>
                                    <input type="text" id="title" name="title" class="form-control"
                                           placeholder="عنوان" value="">
                                    @if ($errors->has('title'))
                                        <div data-field="title" class="text-danger">{{ $errors->first('title') }}
                                        </div>
                                    @endif
                                </div>
                                <div class="col-md-6">
                                    <span>*</span>
                                    <label class="form-label" for="title">کلید</label>
                                    <input type="text" id="slug" name="name" class="form-control"
                                           placeholder="کلید" value="">
                                    @if ($errors->has('name'))
                                        <div data-field="title" class="text-danger">{{ $errors->first('name') }}
                                        </div>
                                    @endif
                                </div>
                                <div class="col-md-6">
                                    <span>*</span>
                                    <label class="form-label" for="state">وضعیت</label>
                                    <div class="position-relative">
                                        <select id="state" name="state" class="form-select">
                                            <option value="1" {{ '1' == old('state') ? 'selected' : '' }}>فعال
                                            </option>
                                            <option value="0" {{ '0' == old('state') ? 'selected' : '' }}>غیر
                                                فعال</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="pt-4">
                    <button type="submit" name="save" class="btn btn-primary me-sm-3 me-1">ثبت</button>
                    <a href="{{ route('admin.portfolio_category.index') }}" type="reset"
                       class="btn btn-label-secondary">انصراف</a>
                </div>
            </form>
        </x-modal>
        <form action="{{ route('admin.bulk.portfolio_categories') }}" method="get">
            <p class="demo-inline-spacing">
                <button type="button" class="btn btn-primary me-1" data-bs-toggle="modal" data-bs-target="#add_portfolio_category">
                    جدید
                </button>
                <button name="publish" type="submit" class="btn btn-success me-1">انتشار</button>
                <button name="unPublish" type="submit" class="btn btn-gray me-1">غیر انتشار</button>
                <button name="delete" type="submit" class="btn btn-danger me-1">حذف</button>
            </p>
            <input type="text" id="items" name="items" value="" style="display: none;">
        </form>
        <h5 class="card-header">{{\Modules\Core\app\Http\Controllers\Helpers\Str::getTitleBoard("دسته بندی نمونه کار")}}</h5>
        <div class="table-responsive text-nowrap">
            <table class="table table-sm">
                <thead>
                <tr>
                    <th>
                        <div class="bulk-ids checkbox-primary m-r-15">
                            <input id="bulk-ids" onClick="toggle(this)" type="checkbox">
                            <label for="bulk-ids">#</label>
                        </div>
                    </th>
                    <th>عنوان</th>
                    <th>لینک</th>
                    <th>نام</th>
                    <th>ایجاد</th>
                    <th>عملیات</th>
                </tr>
                </thead>
                <tbody>

                @foreach ($portfolio_categories as $portfolio_category)
                    <tr>
                        <th>
                            <div class="bulk-ids checkbox-primary m-r-15">
                                <input id="bulk-ids" onClick="syncItems(this)"
                                       name="ids[]"value="{{ $portfolio_category->id }}" type="checkbox">
                                <label for="bulk-ids"></label>
                            </div>
                        </th>
                        <td>
                                <a  href="{{route('admin.education.index')}}">
                                    <b class="active">{{ $portfolio_category->id }} -
                                        {{ $portfolio_category->title }}</b>
                                    <br>
                                </a>
                        </td>
                        <td>                                    <a href="{{env('APP_URL').$portfolio_category->route}}">{{env('APP_URL').$portfolio_category->route}}</a>
                        </td>
                        <td>
                            {{$portfolio_category->name}}
                        </td>

                        <td>
                            @if ($portfolio_category->created_at != null)
                                {{ Verta($portfolio_category->created_at)->format('Y-m-d H:i:s') }}
                            @endif
                        </td>

                        <td>
                            <div class="dropdown">
                                <button type="button" class="btn p-0 dropdown-toggle hide-arrow"
                                        data-bs-toggle="dropdown"><i class="bx bx-dots-vertical-rounded"></i></button>
                                <div class="dropdown-menu">
                                    <button type="button" class="dropdown-item" data-bs-toggle="modal" data-bs-target="#edit_portfolio_category-{{$portfolio_category->id }}">
                                        <i class="bx bx-edit-alt me-1"></i>ویرایش
                                    </button>

                                    <button class="dropdown-item"
                                            onclick="event.preventDefault();confirmDelete('delete-{{ $portfolio_category->id }}')"><i
                                            class="bx bx-trash me-1"></i>حذف</button>
                                    <form id="delete-{{ $portfolio_category->id }}"
                                          action="{{ route('admin.portfolio_category.destroy', $portfolio_category->id) }}" method="POST"
                                          style="display: none;">
                                        {{ csrf_field() }}
                                        {{ method_field('DELETE') }}
                                    </form>
                                </div>
                            </div>
                        </td>
                    </tr>
                @endforeach

                @foreach ($portfolio_categories as $portfolio_category)
                    <x-modal id="edit_portfolio_category-{{$portfolio_category->id}}" size="sm" header="ویرایش دسته بندی نمونه کار">
                        <form id="formData" action="{{ route('admin.portfolio_category.update', $portfolio_category->id) }}" method="post">
                            {{ csrf_field() }}
                            @method('patch')
                            <div class="tab-pane fade active show" id="tab1" role="tabpanel">
                                <div class="row g-3">
                                    <div class="col-md-12">
                                        <div class="row">
                                            <div class="col-md-6">
                                                <span>*</span>
                                                <label class="form-label" for="title">عنوان</label>
                                                <input type="text" id="title" name="title" class="form-control"
                                                       placeholder="عنوان" value="{{$portfolio_category->title}}">
                                                @if ($errors->has('title'))
                                                    <div data-field="title" class="text-danger">{{ $errors->first('title') }}
                                                    </div>
                                                @endif
                                            </div>
                                            <div class="col-md-6">
                                                <span>*</span>
                                                <label class="form-label" for="title">کلید</label>
                                                <input type="text" id="slug" name="name" class="form-control"
                                                       placeholder="کلید" value="{{ $portfolio_category->name }}">
                                                @if ($errors->has('name'))
                                                    <div data-field="title" class="text-danger">{{ $errors->first('name') }}
                                                    </div>
                                                @endif
                                            </div>
                                            <div class="col-md-6">
                                                <span>*</span>
                                                <label class="form-label" for="state">وضعیت</label>
                                                <div class="position-relative">
                                                    <select id="state" name="state" class="form-select">
                                                        @if($portfolio_category->state == 1)
                                                            <option value="1" selected>فعال</option>
                                                            <option value="0">غیر فعال</option>
                                                        @else
                                                            <option value="1">فعال</option>
                                                            <option value="0" selected>غیر فعال</option>
                                                        @endif
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="pt-4">
                                <button type="submit" name="save" class="btn btn-primary me-sm-3 me-1">ثبت</button>
                                <a href="{{ route('admin.portfolio_category.index') }}" type="reset"
                                   class="btn btn-label-secondary">انصراف</a>
                            </div>
                        </form>
                    </x-modal>
                @endforeach

                </tbody>
            </table>
        </div>
    </div>
@endsection
