@extends('core::Dashboard.Frest.Layouts.master')

@section('title')
    داشبورد
@endsection

@section('style')
@endsection

@section('script')
    <script src="{{ asset('modules/core/js/dashboards-analytics.js') }}"></script>
@endsection

@section('content')



    <div class="card">
        <form action="{{ route('admin.bulk.portfolio') }}" method="get">
            <p class="demo-inline-spacing">
                <a class="btn btn-primary me-1" href="{{ route('admin.portfolio.create') }}" role="button"
                   aria-expanded="false">جدید</a>
                <button name="publish" type="submit" class="btn btn-success me-1">انتشار</button>
                <button name="unPublish" type="submit" class="btn btn-gray me-1">غیر انتشار</button>
                <button name="delete" type="submit" class="btn btn-danger me-1">حذف</button>
            </p>
            <input type="text" id="items" name="items" value="" style="display: none;">
        </form>
        <h5 class="card-header">{{\Modules\Core\app\Http\Controllers\Helpers\Str::getTitleBoard("نمونه کار ها")}}</h5>
        <div class="table-responsive text-nowrap">
            <table class="table table-sm">
                <thead>
                <tr>
                    <th>
                        <div class="bulk-ids checkbox-primary m-r-15">
                            <input id="bulk-ids" onClick="toggle(this)" type="checkbox">
                            <label for="bulk-ids">#</label>
                        </div>
                    </th>
                    <th>عنوان</th>
                    <th>لینک</th>
                    <th>ایجاد</th>
                    <th>عملیات</th>
                </tr>
                </thead>
                <tbody>

                @foreach ($portfolios as $portfolio)
                    <tr>
                        <th>
                            <div class="bulk-ids checkbox-primary m-r-15">
                                <input id="bulk-ids" onClick="syncItems(this)"
                                       name="ids[]"value="{{ $portfolio->id }}" type="checkbox">
                                <label for="bulk-ids"></label>
                            </div>
                        </th>

                        <td>
                                <a style="color: blue" href="{{route('admin.portfolio.index')}}">
                                    <b class="active">{{ $portfolio->id }} -
                                        {{ $portfolio->title }}</b>
                                </a>
                        </td>

                        <td>                                    <a href="{{env('APP_URL').$portfolio->route}}">{{env('APP_URL').$portfolio->route}}</a>
                        </td>

                        <td>
                            @if ($portfolio->created_at != null)
                                {{ Verta($portfolio->created_at)->format('Y-m-d H:i:s') }}
                            @endif
                        </td>

                        <td>
                            <div class="dropdown">
                                <button type="button" class="btn p-0 dropdown-toggle hide-arrow"
                                        data-bs-toggle="dropdown"><i class="bx bx-dots-vertical-rounded"></i></button>
                                <div class="dropdown-menu">
                                    <a class="dropdown-item" href="{{ route('admin.portfolio.edit', $portfolio->id) }}"><i
                                            class="bx bx-edit-alt me-1"></i> ویرایش</a>

                                    <button class="dropdown-item"
                                            onclick="event.preventDefault();confirmDelete('delete-{{ $portfolio->id }}')"><i
                                            class="bx bx-trash me-1"></i>حذف</button>
                                    <form id="delete-{{ $portfolio->id }}"
                                          action="{{ route('admin.portfolio.destroy', $portfolio->id) }}" method="POST"
                                          style="display: none;">
                                        {{ csrf_field() }}
                                        {{ method_field('DELETE') }}
                                    </form>
                                </div>
                            </div>
                        </td>
                    </tr>
                @endforeach

                </tbody>
            </table>

        </div>
    </div>
@endsection
