<?php

namespace Modules\Product\app\Http\Controllers\Dashboard\Frest;

use Aws\Script\Composer\Composer;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Modules\Core\app\Http\Controllers\Helpers\File;
use Modules\Product\app\Models\Product;
use Illuminate\Contracts\Support\Renderable;
use Modules\Product\app\Models\Color;
use Modules\Product\app\Models\ProductColor;
use Modules\Product\app\Http\Requests\ProductColorRequest;

class ProductColorController extends Controller
{
    /**
     * Display a listing of the resource.
     * @return Renderable
     */
    public function index(Product $product)
    {
        $colors = $product->colors;
        return view('product::Dashboard.Frest.color.index' , compact('colors' , 'product'));
    }

    /**
     * Show the form for creating a new resource.
     * @return Renderable
     */
    public function create(Product $product)
    {
        $colors = Color::latest()->get();

        return view('product::Dashboard.Frest.color.create' , compact('product' , 'colors'));
    }

    /**
     * Store a newly created resource in storage.
     * @param Request $request
     * @return Renderable
     */
    public function store(ProductColorRequest $request , Product $product)
    {



        // $this->authorize('product.create');
        $color = Color::firstOrCreate(['color_name' => $request->colorName , 'type' =>  $request->type] ,
        [
            'color_name' =>$request->colorName,
            'color'  =>$request->color,
            'type'  =>$request->type,
            'state' >(int)$request->state,
        ]);


        $image = File::uploadByFileManager($request->image);


        ProductColor::create([
            'color_id' => $color->id,
            'product_id' =>$product->id,
            'image' => $image,
            'price_increase' => $request->price_increase,
            'status' => (int)$request->status,
            'default' => (int)$request->default,
        ]);

        return redirect()->route('admin.product-colors' , $product);

    }



    /**
     * Show the form for editing the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function edit(ProductColor $productColor)
    {
        $colors = Color::latest()->get();
        return view('product::Dashboard.Frest.color.edit' , compact('productColor' , 'colors'));
    }

    /**
     * Update the specified resource in storage.
     * @param Request $request
     * @param int $id
     * @return Renderable
     */
    public function update(ProductColorRequest $request, ProductColor $productColor)
    {

        $image = $productColor->image;
        if($request->image != null) {
            $image = File::uploadByFileManager($request->image);
        }
        $color = Color::firstOrCreate(['color_name' => $request->colorName , 'type' =>  $request->type] ,
        [
            'color_name' =>$request->colorName,
            'color'  =>$request->color,
            'type'  =>$request->type,
            'state' >(int)$request->state,

        ]);




        $productColor->update([
            'color_id' => $color->id,
            'price_increase' => $request->price_increase,
            'image' => $image,
        ]);
        return redirect()->route('admin.product-colors' , $productColor->product_id);
    }

    /**
     * Remove the specified resource from storage.
     * @param int $id
     * @return Renderable
     */
    public function destroy(ProductColor $productColor)
    {
        $productColor->delete();
        return redirect()->back();
    }
}
