<?php

namespace Modules\Product\app\Http\Controllers\Dashboard\Frest;


use App\Http\Controllers\Controller;

use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use Barryvdh\DomPDF\Facade\Pdf;
use Modules\Album\app\Http\Requests\Dashboard\Frest\Album\StoreAlbumRequest;
use Modules\Album\app\Http\Requests\Dashboard\Frest\Album\UpdateAlbumRequest;
use Modules\Category\app\Models\Category;
use Modules\Core\app\Http\Controllers\Helpers\File;
use Modules\Core\app\Http\Controllers\Helpers\Str;
use Modules\Field\app\Traits\FieldCustom;
use Modules\Product\app\Http\Requests\Dashboard\Frest\Product\StoreProductRequest;
use Modules\Product\app\Http\Requests\Dashboard\Frest\Product\UpdateProductRequest;
use Modules\Product\app\Models\Product;
use Modules\Service\app\Models\Service;
use Modules\Service\app\Models\ServiceModel;
use Modules\Site\app\Models\Site;
use Modules\Tag\app\Models\Tag;


class ProductController extends Controller
{
    use FieldCustom;
    public function index()
    {

        $this->authorize('product.access');

        $user = Auth::guard('admin')->user();
        $categories = Category::whereState(1)->whereType('products')->whereHas('roles', function ($query)  use ($user) {
             $query->whereIn('id',$user->roles->pluck('role_id'));
        })->get();


        $query = Product::
        when(Request()->tran_id != null,function ($query){
            $query->where('tran_id',Request()->tran_id);
        })
            ->when(Request()->tran_id == null,function ($query){
                $query->where('tran_id',null);
            })
        ->when(!is_null(Request()->q),function ($query){
            return $query->where('title','LIKE','%'.Request()->q."%")
                ->orWhere('id','LIKE','%'.Request()->q."%");
        })
            ->when(!is_null(Request()->main_cat),function ($query){
                return $query->whereIn('main_cat',Request()->main_cat);
            })
            ->when(!is_null(Request()->state),function ($query){
                return $query->whereIn('state',Request()->state);
            })
            ->when(!is_null(Request()->categories),function ($query){
                return $query->whereHas('categories',function ($query){
                    $query->whereIn('id',Request()->categories);
                });
            })
            ->when(!is_null(Request()->start_date), function ($query) {
                $start_date = Str::convertToGregorian(Request()->start_date . ':00');
                return $query->whereDate('created_at','>=',$start_date);
            })
            ->when(!is_null(Request()->end_date), function ($query)  {
                $end_date = Str::convertToGregorian(Request()->end_date . ':00');
                return $query->whereDate('created_at','<=',$end_date);
            })
            ->with('categories','category')
            ->latest('id');




        if(isset($_GET['print'])){
            $product = $query->limit(200)->get();
            return view('product::template.print.product' , compact('product'));
        }

        if(isset($_GET['pdf'])){
            $product = $query->limit(200)->get();
            Pdf::setOption(['dpi' => 150, 'defaultFont' => 'sans-serif']);
            $pdf = Pdf::loadView('template.print.product', ['product' => $product]);
            return $pdf->download('product.pdf');
        }

        if (isset($_GET['excel'])) {
            $items = $query->latest()->get();
            return Excel::download(new NewsExport($items),'product.xlsx');
        }

        $products = $query->paginate(15);

        return view('product::Dashboard.Frest.product.index' , compact('products','categories'));


    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $this->authorize('product.create');

        $trans = Site::where('tran_id',Request()->tran_id)
            ->orWhere('id',Request()->tran_id)->pluck('lang')->toArray();

        $user = Auth::guard('admin')->user();
        $services = Service::where('model','products')->latest()->get();
        $categories = Category::whereState(1)->whereType('products')->whereState(1)->whereHas('roles', function ($query)  use ($user) {
             $query->whereIn('id',$user->roles->pluck('role_id'));
        })->whereNull('parent_id')->get();

        $tags = Tag::all();
        $product = [];

        return view('product::Dashboard.Frest.product.create',compact('tags','product','services','categories','trans'));

    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(StoreProductRequest $request)
    {
        $this->authorize('product.create');


        $image = File::uploadByFileManager($request->image);
        $color_image = File::uploadByFileManager($request->color_image);
        $material_image = File::uploadByFileManager($request->material_image);


        $publish_up = null; $publish_down=null;
        if($request->publish_up != null)
        {
            $publish_up = Str::convertToGregorian($request->publish_up . ':00');
        }

        if($request->publish_down != null)
        {
            $publish_down = Str::convertToGregorian($request->publish_down . ':00');
        }

        $product = Product::create([
            'title' => $request->title,
            'slug' => str_replace(' ', '-', $request->slug),
            'body' => $request->body,
            'image' => $image,
            'color_image' => $color_image,
            'material_image' => $material_image,
            'link' => $request->link,
            'state' => $request->state,
            'lead' => $request->lead,
            'type' => $request->type,
            'publish_up' => $publish_up,
            'publish_down' => $publish_down,
            'main_cat' => $request->main_cat,
            'price' => $request->price,
            'lang' => $request->lang,
            'tran_id' => $request->tran_id,
        ]);



        $tags = json_decode($request->tag);

        $tags_id = [];
        if($tags != null){
            foreach($tags as $tag){
                $tag = Tag::firstOrCreate(['name' => $tag->value]);
                array_push($tags_id,$tag->id);
            }
            $product->tags()->attach($tags_id);
        }

        $product->categories()->attach($request->categories);
        $this->storeCustomField($product,$request->fields);

        $product->services()->delete();

        if(isset($request->service_ids) && count($request->service_ids) > 0){
            foreach ($request->service_ids as $id){
                $product->services()->create([
                    'service_id' => $id,
                    'order' => ServiceModel::where('service_id',$id)->max('order') + 1
                ]);
            }
        }



        if(count($request->input('files')) > 0) {
            foreach ($request->input('files') as $key => $file){
                if($file != null){
                    $product->files()->create([
                        'file' => $file,
                        'desc' => $request->notes[$key],
                        'type' => 'galleries'
                    ]);
                }
            }
        }


        if(isset($_POST['save']))
        {
            Session::flash('success','با موفقیت انجام شد');
            return redirect()->route('admin.product.index');
        }

        return redirect()->route('admin.product.edit',$product->id);





    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $this->authorize('product.edit');
        $product = Product::whereId($id)->with('categories')->first();
        if($product->tran_id != null){
            $tran = Site::find($product->tran_id);
            $trans = $product->translates->pluck('lang')->toArray();
            $trans[] = $product->lang;
        } else {
            $trans = $product->translates->pluck('lang')->toArray();
        }


        $services = Service::where('model','products')->latest()->get();
        $user = Auth::guard('admin')->user();

        $categories = Category::whereState(1)->whereType('products')->whereState(1)->whereHas('roles', function ($query)  use ($user) {
             $query->whereIn('id',$user->roles->pluck('role_id'));
        })->whereNull('parent_id')->get();

        $tags = Tag::all();


        return view('product::Dashboard.Frest.product.edit',compact('product','categories','services','tags','trans'));




    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(UpdateProductRequest $request, $id)
    {
        $this->authorize('product.edit');


        $product = Product::whereId($id)->first();



        $image = $product->image;
        if($request->image != null) {
            $image = File::uploadByFileManager($request->image);
        }

        $material_image = $product->material_image;
        if($request->material_image != null) {
            $material_image = File::uploadByFileManager($request->material_image);
        }
        $color_image = $product->color_image;
        if($request->image != null) {
            $color_image = File::uploadByFileManager($request->color_image);
        }


        $publish_up = $product->publish_up; $publish_down = $product->publish_down;
        if($request->publish_up != null)
        {
            $publish_up = Str::convertToGregorian($request->publish_up . ':00');
        }

        if($request->publish_down != null)
        {
            $publish_down = Str::convertToGregorian($request->publish_down . ':00');
        }

        $product->title = $request->title;
        $product->slug = str_replace(' ', '-', $request->slug);
        $product->body = $request->body;
        $product->image = $image;
        $product->color_image = $color_image;
        $product->material_image = $material_image;
        $product->link = $request->link;
        $product->state = $request->state;
        $product->type = $request->type;
        $product->lead = $request->lead;
        $product->publish_up = $publish_up;
        $product->publish_down = $publish_down;
        $product->main_cat = $request->main_cat;
        $product->price = $request->price;
        $product->lang  = $request->lang;
        $product->update();



        $tags = json_decode($request->tag);
        $tags_id = [];
        if($tags != null){
            foreach($tags as $tag){
                $tag = Tag::firstOrCreate(['name' => $tag->value]);
                array_push($tags_id,$tag->id);
            }
            $product->tags()->sync($tags_id);
        }

        $product->categories()->sync($request->categories);
        $this->storeCustomField($product,$request->fields);



        $product->services()->delete();
        if(isset($request->service_ids) && count($request->service_ids) > 0){
            foreach ($request->service_ids as $id){
                $product->services()->create([
                    'service_id' => $id,
                    'order' => ServiceModel::where('service_id',$id)->max('order') + 1
                ]);
            }
        }

        $product->files()->where('type','galleries')->delete();
        if(count($request->input('files')) > 0) {

            foreach ($request->input('files') as $key => $file){
                if($file != null){
                    $product->files()->create([
                        'file' => $file,
                        'desc' => $request->notes[$key],
                        'type' => 'galleries'
                    ]);
                }
            }
        }




        if(isset($_POST['save']))
        {
            Session::flash('success','با موفقیت انجام شد');
            return redirect()->route('admin.product.index');
        }

        return redirect()->route('admin.product.edit',$product->id);






    }




    public function destroy($id)
    {
        $this->authorize('product.delete');


        $product = Product::find($id);
        $product->delete();


        session::flash('success','با موفقیت انجام شد');
        return redirect()->back();

    }


    public function bulkAction()
    {

        $items = [];
        $items = explode(',',Request()->items);



        if(isset($_GET['delete']))
        {
            $this->authorize('product.delete');
            Product::whereIn('id',$items)->delete();
        }
        if (isset($_GET['unPublish']))
        {
            $this->authorize('product.edit');
            Product::whereIn('id',$items)->update([
                'state' => 0
            ]);
        }
        if(isset($_GET['publish']))
        {
            $this->authorize('product.edit');
            Product::whereIn('id',$items)->update([
                'state' => 1
            ]);
        }



        session::flash('success','با موفقیت انجام شد');
        return redirect()->back();

    }
}
